/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.model.entity;

import java.sql.Timestamp;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.model.dto.DashboardUserDTO;
import org.apache.shenyu.admin.model.dto.DashboardUserModifyPasswordDTO;
import org.apache.shenyu.admin.model.entity.BaseDO;
import org.apache.shenyu.common.utils.UUIDUtils;

public final class DashboardUserDO
extends BaseDO {
    private static final long serialVersionUID = 3464935043890680423L;
    private String userName;
    private String password;
    private Integer role;
    private Boolean enabled;
    private List<String> roles;

    public DashboardUserDO() {
    }

    public DashboardUserDO(String userName, String password, Integer role, Boolean enabled, List<String> roles) {
        this.userName = userName;
        this.password = password;
        this.role = role;
        this.enabled = enabled;
        this.roles = roles;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Integer getRole() {
        return this.role;
    }

    public void setRole(Integer role) {
        this.role = role;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    public static DashboardUserDOBuilder builder() {
        return new DashboardUserDOBuilder();
    }

    public static DashboardUserDO buildDashboardUserDO(DashboardUserModifyPasswordDTO dashboardUserModifyPasswordDTO) {
        return Optional.ofNullable(dashboardUserModifyPasswordDTO).map(item -> {
            Timestamp currentTime = new Timestamp(System.currentTimeMillis());
            return DashboardUserDO.builder().password(item.getPassword()).dateUpdated(currentTime).id(item.getId()).build();
        }).orElse(null);
    }

    public static DashboardUserDO buildDashboardUserDO(DashboardUserDTO dashboardUserDTO) {
        return Optional.ofNullable(dashboardUserDTO).map(item -> {
            Timestamp currentTime = new Timestamp(System.currentTimeMillis());
            DashboardUserDO dashboardUserDO = DashboardUserDO.builder().userName(item.getUserName()).password(item.getPassword()).role(item.getRole()).roles(item.getRoles()).dateUpdated(currentTime).build();
            if (StringUtils.isEmpty((CharSequence)item.getId())) {
                dashboardUserDO.setId(UUIDUtils.getInstance().generateShortUuid());
                dashboardUserDO.setEnabled(true);
                dashboardUserDO.setDateCreated(currentTime);
            } else {
                dashboardUserDO.setId(item.getId());
                dashboardUserDO.setEnabled(item.getEnabled());
            }
            return dashboardUserDO;
        }).orElse(null);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DashboardUserDO)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DashboardUserDO that = (DashboardUserDO)o;
        return Objects.equals(this.userName, that.userName) && Objects.equals(this.password, that.password) && Objects.equals(this.role, that.role) && Objects.equals(this.enabled, that.enabled) && Objects.equals(this.roles, that.roles);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.userName, this.password, this.role, this.enabled, this.roles);
    }

    public static final class DashboardUserDOBuilder {
        private String id;
        private Timestamp dateCreated;
        private Timestamp dateUpdated;
        private String userName;
        private String password;
        private Integer role;
        private Boolean enabled;
        private List<String> roles;

        private DashboardUserDOBuilder() {
        }

        public DashboardUserDOBuilder id(String id) {
            this.id = id;
            return this;
        }

        public DashboardUserDOBuilder dateCreated(Timestamp dateCreated) {
            this.dateCreated = dateCreated;
            return this;
        }

        public DashboardUserDOBuilder dateUpdated(Timestamp dateUpdated) {
            this.dateUpdated = dateUpdated;
            return this;
        }

        public DashboardUserDOBuilder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public DashboardUserDOBuilder password(String password) {
            this.password = password;
            return this;
        }

        public DashboardUserDOBuilder role(Integer role) {
            this.role = role;
            return this;
        }

        public DashboardUserDOBuilder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public DashboardUserDOBuilder roles(List<String> roles) {
            this.roles = roles;
            return this;
        }

        public DashboardUserDO build() {
            DashboardUserDO dashboardUserDO = new DashboardUserDO();
            dashboardUserDO.setId(this.id);
            dashboardUserDO.setDateCreated(this.dateCreated);
            dashboardUserDO.setDateUpdated(this.dateUpdated);
            dashboardUserDO.setUserName(this.userName);
            dashboardUserDO.setPassword(this.password);
            dashboardUserDO.setRole(this.role);
            dashboardUserDO.setEnabled(this.enabled);
            dashboardUserDO.setRoles(this.roles);
            return dashboardUserDO;
        }
    }
}

