/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.impl;

import com.google.common.collect.Maps;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.shenyu.admin.mapper.AlertReceiverMapper;
import org.apache.shenyu.admin.service.AlertDispatchService;
import org.apache.shenyu.alert.AlertNotifyHandler;
import org.apache.shenyu.alert.exception.AlertNoticeException;
import org.apache.shenyu.alert.model.AlertReceiverDTO;
import org.apache.shenyu.common.dto.AlarmContent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AlertDispatchServiceImpl
implements AlertDispatchService,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(AlertDispatchServiceImpl.class);
    private final Map<Byte, AlertNotifyHandler> alertNotifyHandlerMap;
    private final AlertReceiverMapper alertReceiverMapper;
    private final AtomicReference<List<AlertReceiverDTO>> alertReceiverReference;
    private final ThreadPoolExecutor workerExecutor;

    public AlertDispatchServiceImpl(List<AlertNotifyHandler> alertNotifyHandlerList, AlertReceiverMapper alertReceiverMapper) {
        this.alertReceiverMapper = alertReceiverMapper;
        this.alertReceiverReference = new AtomicReference();
        this.alertNotifyHandlerMap = Maps.newHashMapWithExpectedSize((int)alertNotifyHandlerList.size());
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setUncaughtExceptionHandler((thread, throwable) -> {
            log.error("workerExecutor has uncaughtException.");
            log.error(throwable.getMessage(), throwable);
        }).setDaemon(true).setNameFormat("alerter-worker-%d").build();
        this.workerExecutor = new ThreadPoolExecutor(3, 3, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(65536), threadFactory, new ThreadPoolExecutor.CallerRunsPolicy());
        alertNotifyHandlerList.forEach(r -> this.alertNotifyHandlerMap.put(r.type(), (AlertNotifyHandler)r));
    }

    @Override
    public void dispatchAlert(AlarmContent alarmContent) {
        DispatchTask task = new DispatchTask(alarmContent);
        this.workerExecutor.submit(task);
    }

    @Override
    public void clearCache() {
        this.alertReceiverReference.set(null);
    }

    @Override
    public boolean sendNoticeMsg(AlertReceiverDTO receiver, AlarmContent alert) {
        if (receiver == null || receiver.getType() == null) {
            log.warn("DispatcherAlarm-sendNoticeMsg params is empty alert:[{}], receiver:[{}]", (Object)alert, (Object)receiver);
            return false;
        }
        byte type = receiver.getType();
        if (this.alertNotifyHandlerMap.containsKey(type)) {
            this.alertNotifyHandlerMap.get(type).send(receiver, alert);
            return true;
        }
        return false;
    }

    public void destroy() throws Exception {
        if (this.workerExecutor != null) {
            this.workerExecutor.shutdownNow();
        }
    }

    private final class DispatchTask
    implements Runnable {
        private final AlarmContent alert;

        private DispatchTask(AlarmContent alert) {
            this.alert = alert;
        }

        @Override
        public void run() {
            if (Objects.nonNull(this.alert)) {
                this.sendNotify(this.alert);
            }
        }

        private void sendNotify(AlarmContent alert) {
            List<AlertReceiverDTO> receivers = this.matchReceiverByRules(alert);
            for (AlertReceiverDTO receiver : receivers) {
                try {
                    AlertDispatchServiceImpl.this.sendNoticeMsg(receiver, alert);
                }
                catch (AlertNoticeException e) {
                    log.warn("DispatchTask sendNoticeMsg error, message: {}", (Object)e.getMessage());
                }
            }
        }

        private List<AlertReceiverDTO> matchReceiverByRules(AlarmContent alert) {
            List<AlertReceiverDTO> dtoList = (List<AlertReceiverDTO>)AlertDispatchServiceImpl.this.alertReceiverReference.get();
            if (dtoList == null) {
                dtoList = AlertDispatchServiceImpl.this.alertReceiverMapper.selectAll();
                AlertDispatchServiceImpl.this.alertReceiverReference.set(dtoList);
            }
            return dtoList.stream().filter(item -> {
                if (item.isEnable()) {
                    boolean levelMatch;
                    if (item.isMatchAll()) {
                        return true;
                    }
                    if (!CollectionUtils.isEmpty((Collection)item.getLevels()) && !(levelMatch = item.getLevels().stream().anyMatch(level -> level.byteValue() == alert.getLevel()))) {
                        return false;
                    }
                    if (!CollectionUtils.isEmpty((Map)item.getLabels())) {
                        return item.getLabels().entrySet().stream().anyMatch(entry -> {
                            if (alert.getLabels() == null || !alert.getLabels().containsKey(entry.getKey())) {
                                return false;
                            }
                            String labelValue = (String)alert.getLabels().get(entry.getKey());
                            return Objects.equals(labelValue, entry.getValue());
                        });
                    }
                    return true;
                }
                return false;
            }).collect(Collectors.toList());
        }
    }
}

