/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.impl;

import java.sql.Timestamp;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.mapper.MockRequestRecordMapper;
import org.apache.shenyu.admin.model.dto.MockRequestRecordDTO;
import org.apache.shenyu.admin.model.entity.MockRequestRecordDO;
import org.apache.shenyu.admin.model.page.CommonPager;
import org.apache.shenyu.admin.model.page.PageResultUtils;
import org.apache.shenyu.admin.model.query.MockRequestRecordQuery;
import org.apache.shenyu.admin.model.vo.MockRequestRecordVO;
import org.apache.shenyu.admin.service.MockRequestRecordService;
import org.apache.shenyu.common.utils.UUIDUtils;
import org.springframework.stereotype.Service;

@Service
public class MockRequestRecordServiceImpl
implements MockRequestRecordService {
    private final MockRequestRecordMapper mockRequestRecordMapper;

    public MockRequestRecordServiceImpl(MockRequestRecordMapper mockRequestRecordMapper) {
        this.mockRequestRecordMapper = mockRequestRecordMapper;
    }

    @Override
    public int createOrUpdate(MockRequestRecordDTO mockRequestRecordDTO) {
        return StringUtils.isBlank((CharSequence)mockRequestRecordDTO.getId()) ? this.create(mockRequestRecordDTO) : this.update(mockRequestRecordDTO);
    }

    @Override
    public int delete(String id) {
        MockRequestRecordDO mockRequestRecordDO = this.mockRequestRecordMapper.queryById(id);
        if (mockRequestRecordDO == null) {
            return 0;
        }
        return this.mockRequestRecordMapper.deleteById(id);
    }

    @Override
    public int batchDelete(List<String> ids) {
        return this.mockRequestRecordMapper.batchDelete(ids);
    }

    @Override
    public MockRequestRecordVO findById(String id) {
        MockRequestRecordVO mockRequestRecordVO = new MockRequestRecordVO();
        if (StringUtils.isBlank((CharSequence)id)) {
            return mockRequestRecordVO;
        }
        MockRequestRecordDO mockRequestRecordDO = this.mockRequestRecordMapper.queryById(id);
        if (mockRequestRecordDO == null) {
            return mockRequestRecordVO;
        }
        return MockRequestRecordVO.buildMockRequestRecordVO(mockRequestRecordDO);
    }

    @Override
    public CommonPager<MockRequestRecordVO> listByPage(MockRequestRecordQuery mockRequestRecordQuery) {
        List<MockRequestRecordDO> list = this.mockRequestRecordMapper.selectByQuery(mockRequestRecordQuery);
        return PageResultUtils.result(mockRequestRecordQuery.getPageParameter(), () -> list.stream().map(MockRequestRecordVO::buildMockRequestRecordVO).collect(Collectors.toList()));
    }

    private int update(MockRequestRecordDTO mockRequestRecordDTO) {
        if (mockRequestRecordDTO == null || mockRequestRecordDTO.getId() == null) {
            return 0;
        }
        Timestamp currentTime = new Timestamp(System.currentTimeMillis());
        MockRequestRecordDO mockRequestRecordDO = MockRequestRecordDO.builder().id(mockRequestRecordDTO.getId()).apiId(mockRequestRecordDTO.getApiId()).header(mockRequestRecordDTO.getHeader()).host(mockRequestRecordDTO.getHost()).port(mockRequestRecordDTO.getPort()).query(mockRequestRecordDTO.getQuery()).url(mockRequestRecordDTO.getUrl()).pathVariable(mockRequestRecordDTO.getPathVariable()).body(mockRequestRecordDTO.getBody()).dateUpdated(currentTime).build();
        return this.mockRequestRecordMapper.update(mockRequestRecordDO);
    }

    private int create(MockRequestRecordDTO mockRequestRecordDTO) {
        if (mockRequestRecordDTO == null) {
            return 0;
        }
        Timestamp currentTime = new Timestamp(System.currentTimeMillis());
        MockRequestRecordDO mockRequestRecordDO = MockRequestRecordDO.builder().id(UUIDUtils.getInstance().generateShortUuid()).apiId(mockRequestRecordDTO.getApiId()).header(mockRequestRecordDTO.getHeader()).host(mockRequestRecordDTO.getHost()).query(mockRequestRecordDTO.getQuery()).port(mockRequestRecordDTO.getPort()).url(mockRequestRecordDTO.getUrl()).pathVariable(mockRequestRecordDTO.getPathVariable()).body(mockRequestRecordDTO.getBody()).dateUpdated(currentTime).dateCreated(currentTime).build();
        return this.mockRequestRecordMapper.insert(mockRequestRecordDO);
    }

    @Override
    public MockRequestRecordVO queryByApiId(String apiId) {
        MockRequestRecordQuery mockRequestRecordQuery = new MockRequestRecordQuery();
        mockRequestRecordQuery.setApiId(apiId);
        List<MockRequestRecordDO> mockRequestRecordDOList = this.mockRequestRecordMapper.selectByQuery(mockRequestRecordQuery);
        return mockRequestRecordDOList.isEmpty() ? new MockRequestRecordVO() : MockRequestRecordVO.buildMockRequestRecordVO(mockRequestRecordDOList.get(0));
    }
}

