/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.model.dto.ProxyGatewayDTO;
import org.apache.shenyu.admin.model.entity.AppAuthDO;
import org.apache.shenyu.admin.model.vo.ShenyuDictVO;
import org.apache.shenyu.admin.service.AppAuthService;
import org.apache.shenyu.admin.service.SandboxService;
import org.apache.shenyu.admin.service.ShenyuDictService;
import org.apache.shenyu.admin.utils.Assert;
import org.apache.shenyu.admin.utils.HttpUtils;
import org.apache.shenyu.admin.utils.ShenyuSignatureUtils;
import org.apache.shenyu.admin.utils.UploadUtils;
import org.apache.shenyu.common.exception.ShenyuException;
import org.apache.shenyu.common.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UriUtils;

@Service
public class SandboxServiceImpl
implements SandboxService {
    private static final Logger LOG = LoggerFactory.getLogger(SandboxServiceImpl.class);
    private static final HttpUtils HTTP_UTILS = new HttpUtils();
    private final AppAuthService appAuthService;
    private final ShenyuDictService shenyuDictService;

    public SandboxServiceImpl(AppAuthService appAuthService, ShenyuDictService shenyuDictService) {
        this.appAuthService = appAuthService;
        this.shenyuDictService = shenyuDictService;
    }

    @Override
    public void requestProxyGateway(ProxyGatewayDTO proxyGatewayDTO, HttpServletRequest request, HttpServletResponse response) throws IOException {
        Map<String, String> header = this.buildReqHeaders(proxyGatewayDTO);
        String appKey = proxyGatewayDTO.getAppKey();
        UriComponents uriComponents = UriComponentsBuilder.fromHttpUrl((String)proxyGatewayDTO.getRequestUrl()).build();
        String proxyHostPort = this.getHostPort(proxyGatewayDTO.getRequestUrl());
        Set<String> permitHostPorts = this.getPermitHostPorts();
        if (!permitHostPorts.contains(proxyHostPort)) {
            LOG.error("Unsecure access, details: {}", (Object)proxyGatewayDTO.getRequestUrl());
            throw new ShenyuException(proxyHostPort + " is not allowed.");
        }
        String signContent = null;
        String sign = null;
        if (StringUtils.isNotEmpty((CharSequence)appKey)) {
            String timestamp = String.valueOf(Instant.now().toEpochMilli());
            String secureKey = this.getSecureKey(appKey);
            Assert.notBlack(secureKey, "sign appKey does not exist.");
            signContent = ShenyuSignatureUtils.getSignContent(secureKey, timestamp, uriComponents.getPath());
            sign = ShenyuSignatureUtils.generateSign(signContent);
            header.put("timestamp", timestamp);
            header.put("appKey", appKey);
            header.put("sign", sign);
            header.put("version", "1.0.0");
        }
        Map<String, Object> reqParams = this.buildReqBizParams(proxyGatewayDTO);
        List<HttpUtils.UploadFile> files = this.uploadFiles(request);
        Response resp = HTTP_UTILS.requestCall(uriComponents.toUriString(), reqParams, header, HttpUtils.HTTPMethod.fromValue(proxyGatewayDTO.getHttpMethod()), files);
        ResponseBody body = resp.body();
        if (Objects.isNull(body)) {
            return;
        }
        if (StringUtils.isNotEmpty((CharSequence)appKey)) {
            response.addHeader("sandbox-beforesign", UriUtils.encode((String)signContent, (Charset)StandardCharsets.UTF_8));
            response.addHeader("sandbox-sign", UriUtils.encode((String)sign, (Charset)StandardCharsets.UTF_8));
        }
        IOUtils.copy((InputStream)body.byteStream(), (OutputStream)response.getOutputStream());
        response.flushBuffer();
    }

    private Set<String> getPermitHostPorts() {
        List<ShenyuDictVO> dictVOList = this.shenyuDictService.list("apidocEnv");
        Set<String> hostPorts = dictVOList.stream().filter(ShenyuDictVO::getEnabled).map(dictVO -> this.getHostPort(dictVO.getDictValue())).collect(Collectors.toSet());
        return hostPorts;
    }

    private String getHostPort(String httpUrl) {
        UriComponents uriComponent = UriComponentsBuilder.fromHttpUrl((String)httpUrl).build();
        return uriComponent.getHost() + ":" + org.apache.shenyu.common.utils.UriUtils.getActualPort((String)uriComponent.getScheme(), (Integer)uriComponent.getPort());
    }

    private Map<String, String> buildReqHeaders(ProxyGatewayDTO proxyGatewayDTO) {
        HashMap<String, String> reqHeaders = new HashMap<String, String>();
        try {
            String reqJson = JsonUtils.toJson((Object)proxyGatewayDTO.getHeaders());
            Map reqMap = JsonUtils.jsonToMap((String)reqJson, String.class);
            LOG.info("Sandbox Request Headers. toMap={}", (Object)JsonUtils.toJson((Object)reqMap));
            reqHeaders.putAll(reqMap);
        }
        catch (Exception e) {
            LOG.error("proxyGateway JsonUtils.toMap error={}", (Object)e.getMessage());
        }
        return reqHeaders;
    }

    private Map<String, Object> buildReqBizParams(ProxyGatewayDTO proxyGatewayDTO) {
        HashMap<String, Object> reqParams = new HashMap<String, Object>();
        try {
            Map reqMap = JsonUtils.toMap((Object)proxyGatewayDTO.getBizParam());
            LOG.info("sandbox Request Params. toMap={}", (Object)JsonUtils.toJson((Object)reqMap));
            reqParams.putAll(reqMap);
        }
        catch (Exception e) {
            LOG.error("proxyGateway JsonUtils.toMap error={}", (Object)e.getMessage());
        }
        return reqParams;
    }

    private String getSecureKey(String appKey) {
        AppAuthDO appAuthDO = this.appAuthService.findByAppKey(appKey);
        return Objects.nonNull(appAuthDO) ? appAuthDO.getAppSecret() : null;
    }

    private List<HttpUtils.UploadFile> uploadFiles(HttpServletRequest request) {
        Collection<MultipartFile> uploadFiles = UploadUtils.getUploadFiles(request);
        return uploadFiles.stream().map(multipartFile -> {
            try {
                return new HttpUtils.UploadFile(multipartFile.getName(), multipartFile.getOriginalFilename(), multipartFile.getBytes());
            }
            catch (IOException e) {
                LOG.error("upload file fail", (Throwable)e);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

