/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.aspect.annotation.DataPermission;
import org.apache.shenyu.admin.aspect.annotation.Pageable;
import org.apache.shenyu.admin.discovery.DiscoveryLevel;
import org.apache.shenyu.admin.discovery.DiscoveryProcessor;
import org.apache.shenyu.admin.discovery.DiscoveryProcessorHolder;
import org.apache.shenyu.admin.listener.DataChangedEvent;
import org.apache.shenyu.admin.mapper.DiscoveryHandlerMapper;
import org.apache.shenyu.admin.mapper.DiscoveryMapper;
import org.apache.shenyu.admin.mapper.DiscoveryRelMapper;
import org.apache.shenyu.admin.mapper.DiscoveryUpstreamMapper;
import org.apache.shenyu.admin.mapper.PluginMapper;
import org.apache.shenyu.admin.mapper.SelectorConditionMapper;
import org.apache.shenyu.admin.mapper.SelectorMapper;
import org.apache.shenyu.admin.model.dto.ProxySelectorDTO;
import org.apache.shenyu.admin.model.dto.SelectorConditionDTO;
import org.apache.shenyu.admin.model.dto.SelectorDTO;
import org.apache.shenyu.admin.model.entity.BaseDO;
import org.apache.shenyu.admin.model.entity.DiscoveryDO;
import org.apache.shenyu.admin.model.entity.DiscoveryHandlerDO;
import org.apache.shenyu.admin.model.entity.DiscoveryUpstreamDO;
import org.apache.shenyu.admin.model.entity.PluginDO;
import org.apache.shenyu.admin.model.entity.SelectorConditionDO;
import org.apache.shenyu.admin.model.entity.SelectorDO;
import org.apache.shenyu.admin.model.event.plugin.BatchPluginDeletedEvent;
import org.apache.shenyu.admin.model.page.CommonPager;
import org.apache.shenyu.admin.model.page.PageResultUtils;
import org.apache.shenyu.admin.model.query.SelectorConditionQuery;
import org.apache.shenyu.admin.model.query.SelectorQuery;
import org.apache.shenyu.admin.model.query.SelectorQueryCondition;
import org.apache.shenyu.admin.model.vo.DiscoveryUpstreamVO;
import org.apache.shenyu.admin.model.vo.DiscoveryVO;
import org.apache.shenyu.admin.model.vo.SelectorConditionVO;
import org.apache.shenyu.admin.model.vo.SelectorVO;
import org.apache.shenyu.admin.service.SelectorService;
import org.apache.shenyu.admin.service.publish.SelectorEventPublisher;
import org.apache.shenyu.admin.transfer.ConditionTransfer;
import org.apache.shenyu.admin.transfer.DiscoveryTransfer;
import org.apache.shenyu.admin.utils.SelectorUtil;
import org.apache.shenyu.admin.utils.SessionUtil;
import org.apache.shenyu.common.dto.ConditionData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.enums.ConfigGroupEnum;
import org.apache.shenyu.common.enums.DataEventTypeEnum;
import org.apache.shenyu.common.enums.MatchModeEnum;
import org.apache.shenyu.common.enums.SelectorTypeEnum;
import org.apache.shenyu.common.utils.ContextPathUtils;
import org.apache.shenyu.common.utils.ListUtil;
import org.apache.shenyu.register.common.dto.MetaDataRegisterDTO;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SelectorServiceImpl
implements SelectorService {
    private final SelectorMapper selectorMapper;
    private final SelectorConditionMapper selectorConditionMapper;
    private final PluginMapper pluginMapper;
    private final ApplicationEventPublisher eventPublisher;
    private final SelectorEventPublisher selectorEventPublisher;
    private final DiscoveryHandlerMapper discoveryHandlerMapper;
    private final DiscoveryUpstreamMapper discoveryUpstreamMapper;
    private final DiscoveryMapper discoveryMapper;
    private final DiscoveryRelMapper discoveryRelMapper;
    private final DiscoveryProcessorHolder discoveryProcessorHolder;

    public SelectorServiceImpl(SelectorMapper selectorMapper, SelectorConditionMapper selectorConditionMapper, PluginMapper pluginMapper, ApplicationEventPublisher eventPublisher, DiscoveryMapper discoveryMapper, DiscoveryHandlerMapper discoveryHandlerMapper, DiscoveryRelMapper discoveryRelMapper, DiscoveryUpstreamMapper discoveryUpstreamMapper, DiscoveryProcessorHolder discoveryProcessorHolder, SelectorEventPublisher selectorEventPublisher) {
        this.selectorMapper = selectorMapper;
        this.selectorConditionMapper = selectorConditionMapper;
        this.pluginMapper = pluginMapper;
        this.discoveryMapper = discoveryMapper;
        this.discoveryHandlerMapper = discoveryHandlerMapper;
        this.discoveryRelMapper = discoveryRelMapper;
        this.discoveryUpstreamMapper = discoveryUpstreamMapper;
        this.discoveryProcessorHolder = discoveryProcessorHolder;
        this.eventPublisher = eventPublisher;
        this.selectorEventPublisher = selectorEventPublisher;
    }

    @Override
    public void doConditionPreProcessing(SelectorQueryCondition condition) {
        if (SessionUtil.isAdmin()) {
            condition.setUserId(null);
        }
    }

    @Override
    public List<SelectorVO> searchByCondition(SelectorQueryCondition condition) {
        condition.init();
        List<SelectorVO> list = this.selectorMapper.selectByCondition(condition);
        for (SelectorVO selector : list) {
            selector.setMatchModeName(MatchModeEnum.getMatchModeByCode((int)selector.getMatchMode()));
            selector.setTypeName(SelectorTypeEnum.getSelectorTypeByCode((int)selector.getType()));
        }
        return list;
    }

    @Override
    public String registerDefault(SelectorDTO selectorDTO) {
        SelectorDO selectorDO = SelectorDO.buildSelectorDO(selectorDTO);
        if (StringUtils.isEmpty((CharSequence)selectorDTO.getId())) {
            this.selectorMapper.insertSelective(selectorDO);
            this.createCondition(selectorDO.getId(), selectorDTO.getSelectorConditions());
        }
        this.publishEvent(selectorDO, selectorDTO.getSelectorConditions(), Collections.emptyList());
        return selectorDO.getId();
    }

    @Override
    public String registerDefault(MetaDataRegisterDTO dto, String pluginName, String selectorHandler) {
        String contextPath = ContextPathUtils.buildContextPath((String)dto.getContextPath(), (String)dto.getAppName());
        SelectorDO selectorDO = this.findByNameAndPluginName(contextPath, pluginName);
        if (Objects.isNull(selectorDO)) {
            SelectorDTO selectorDTO = SelectorUtil.buildSelectorDTO(contextPath, this.pluginMapper.selectByName(pluginName).getId());
            selectorDTO.setHandle(selectorHandler);
            return this.registerDefault(selectorDTO);
        }
        return selectorDO.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int createOrUpdate(SelectorDTO selectorDTO) {
        return SelectorService.super.createOrUpdate(selectorDTO);
    }

    @Override
    public int create(SelectorDTO selectorDTO) {
        SelectorDO selectorDO = SelectorDO.buildSelectorDO(selectorDTO);
        int selectorCount = this.selectorMapper.insertSelective(selectorDO);
        selectorDTO.setId(selectorDO.getId());
        this.createCondition(selectorDO.getId(), selectorDTO.getSelectorConditions());
        this.publishEvent(selectorDO, selectorDTO.getSelectorConditions(), Collections.emptyList());
        if (selectorCount > 0) {
            this.selectorEventPublisher.onCreated(selectorDO);
        }
        return selectorCount;
    }

    @Override
    public int update(SelectorDTO selectorDTO) {
        List currentCondition;
        SelectorDO before = this.selectorMapper.selectById(selectorDTO.getId());
        SelectorDO selectorDO = SelectorDO.buildSelectorDO(selectorDTO);
        int selectorCount = this.selectorMapper.updateSelective(selectorDO);
        List<SelectorConditionDO> beforeSelectorConditionList = this.selectorConditionMapper.selectByQuery(new SelectorConditionQuery(selectorDO.getId()));
        List beforeCondition = beforeSelectorConditionList.stream().map(selectorConditionDO -> SelectorConditionDTO.builder().selectorId(selectorConditionDO.getSelectorId()).operator(selectorConditionDO.getOperator()).paramName(selectorConditionDO.getParamName()).paramType(selectorConditionDO.getParamType()).paramValue(selectorConditionDO.getParamValue()).build()).collect(Collectors.toList());
        if (CollectionUtils.isEqualCollection(beforeCondition, currentCondition = selectorDTO.getSelectorConditions().stream().map(selectorConditionDTO -> SelectorConditionDTO.builder().selectorId(selectorConditionDTO.getSelectorId()).operator(selectorConditionDTO.getOperator()).paramName(selectorConditionDTO.getParamName()).paramType(selectorConditionDTO.getParamType()).paramValue(selectorConditionDTO.getParamValue()).build()).collect(Collectors.toList()))) {
            beforeSelectorConditionList = Collections.emptyList();
        }
        this.selectorConditionMapper.deleteByQuery(new SelectorConditionQuery(selectorDO.getId()));
        this.createCondition(selectorDO.getId(), selectorDTO.getSelectorConditions());
        this.publishEvent(selectorDO, selectorDTO.getSelectorConditions(), beforeSelectorConditionList);
        if (selectorCount > 0) {
            this.selectorEventPublisher.onUpdated(selectorDO, before);
        }
        return selectorCount;
    }

    @Override
    public int updateSelective(SelectorDO selectorDO) {
        SelectorDO before = this.selectorMapper.selectById(selectorDO.getId());
        int updateCount = this.selectorMapper.updateSelective(selectorDO);
        if (updateCount > 0) {
            this.selectorEventPublisher.onUpdated(selectorDO, before);
        }
        return updateCount;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int delete(List<String> ids) {
        List<SelectorDO> selectors = this.selectorMapper.selectByIdSet(new TreeSet<String>(ids));
        List<PluginDO> pluginDOS = this.pluginMapper.selectByIds(ListUtil.map(selectors, SelectorDO::getPluginId));
        this.unbindDiscovery(selectors, pluginDOS);
        return this.deleteSelector(selectors, pluginDOS);
    }

    private void unbindDiscovery(List<SelectorDO> selectors, List<PluginDO> pluginDOS) {
        Map pluginMap = ListUtil.toMap(pluginDOS, BaseDO::getId, PluginDO::getName);
        for (SelectorDO selector : selectors) {
            DiscoveryHandlerDO discoveryHandlerDO = this.discoveryHandlerMapper.selectBySelectorId(selector.getId());
            if (Objects.isNull(discoveryHandlerDO)) continue;
            this.discoveryHandlerMapper.delete(discoveryHandlerDO.getId());
            this.discoveryRelMapper.deleteByDiscoveryHandlerId(discoveryHandlerDO.getId());
            this.discoveryUpstreamMapper.deleteByDiscoveryHandlerId(discoveryHandlerDO.getId());
            DiscoveryDO discoveryDO = this.discoveryMapper.selectById(discoveryHandlerDO.getDiscoveryId());
            if (Objects.isNull(discoveryDO)) continue;
            DiscoveryProcessor discoveryProcessor = this.discoveryProcessorHolder.chooseProcessor(discoveryDO.getType());
            ProxySelectorDTO proxySelectorDTO = new ProxySelectorDTO();
            proxySelectorDTO.setName(selector.getName());
            proxySelectorDTO.setPluginName(pluginMap.getOrDefault(selector.getId(), ""));
            discoveryProcessor.removeProxySelector(DiscoveryTransfer.INSTANCE.mapToDTO(discoveryHandlerDO), proxySelectorDTO);
            if (!DiscoveryLevel.SELECTOR.getCode().equals(discoveryDO.getLevel())) continue;
            discoveryProcessor.removeDiscovery(discoveryDO);
            this.discoveryMapper.delete(discoveryDO.getId());
        }
    }

    @Override
    public SelectorVO findById(String id) {
        List conditions = ListUtil.map(this.selectorConditionMapper.selectByQuery(new SelectorConditionQuery(id)), SelectorConditionVO::buildSelectorConditionVO);
        SelectorVO selectorVO = SelectorVO.buildSelectorVO(this.selectorMapper.selectById(id), conditions);
        DiscoveryHandlerDO discoveryHandlerDO = this.discoveryHandlerMapper.selectBySelectorId(id);
        if (Objects.nonNull(discoveryHandlerDO)) {
            selectorVO.setDiscoveryHandler(DiscoveryTransfer.INSTANCE.mapToVo(discoveryHandlerDO));
            String discoveryId = discoveryHandlerDO.getDiscoveryId();
            DiscoveryDO discoveryDO = this.discoveryMapper.selectById(discoveryId);
            DiscoveryVO discoveryVO = DiscoveryTransfer.INSTANCE.mapToVo(discoveryDO);
            selectorVO.setDiscoveryVO(discoveryVO);
            List<DiscoveryUpstreamDO> discoveryUpstreamDOS = this.discoveryUpstreamMapper.selectByDiscoveryHandlerId(discoveryHandlerDO.getId());
            Optional.ofNullable(discoveryUpstreamDOS).ifPresent(list -> {
                List<DiscoveryUpstreamVO> upstreamVOS = list.stream().map(DiscoveryTransfer.INSTANCE::mapToVo).collect(Collectors.toList());
                selectorVO.setDiscoveryUpstreams(upstreamVOS);
            });
        }
        return selectorVO;
    }

    @Override
    public SelectorDO findByName(String name) {
        List<SelectorDO> doList = this.selectorMapper.selectByName(name);
        return CollectionUtils.isNotEmpty(doList) ? doList.get(0) : null;
    }

    @Override
    public List<SelectorDO> findListByName(String name) {
        return this.selectorMapper.selectByName(name);
    }

    @Override
    public SelectorDO findByNameAndPluginName(String name, String pluginName) {
        PluginDO pluginDO = this.pluginMapper.selectByName(pluginName);
        return this.selectorMapper.findByNameAndPluginId(name, pluginDO.getId());
    }

    @Override
    public SelectorDO findByNameAndPluginNameForUpdate(String name, String pluginName) {
        PluginDO pluginDO = this.pluginMapper.selectByNameForUpdate(pluginName);
        return this.selectorMapper.findByNameAndPluginId(name, pluginDO.getId());
    }

    @Override
    public List<SelectorDO> findByNameAndPluginNames(String name, List<String> pluginNames) {
        List<PluginDO> pluginDOList = this.pluginMapper.selectByNames(pluginNames);
        if (CollectionUtils.isEmpty(pluginDOList)) {
            return Lists.newArrayList();
        }
        List<String> pluginIds = pluginDOList.stream().map(it -> it.getId()).collect(Collectors.toList());
        SelectorQuery selectorQuery = new SelectorQuery();
        selectorQuery.setName(name);
        selectorQuery.setPluginIds(pluginIds);
        return this.selectorMapper.selectByQuery(selectorQuery);
    }

    @Override
    public SelectorData buildByName(String name) {
        return this.buildSelectorData(this.findByName(name));
    }

    @Override
    public SelectorData buildByName(String name, String pluginName) {
        return this.buildSelectorData(this.findByNameAndPluginName(name, pluginName));
    }

    @Override
    @DataPermission(dataType="selector")
    @Pageable
    public CommonPager<SelectorVO> listByPageWithPermission(SelectorQuery selectorQuery) {
        return this.listByPage(selectorQuery);
    }

    @Override
    public CommonPager<SelectorVO> listByPage(SelectorQuery selectorQuery) {
        return PageResultUtils.result(selectorQuery.getPageParameter(), () -> this.selectorMapper.selectByQuery(selectorQuery).stream().map(SelectorVO::buildSelectorVO).collect(Collectors.toList()));
    }

    @Override
    public List<SelectorData> findByPluginId(String pluginId) {
        return this.buildSelectorDataList(this.selectorMapper.findByPluginId(pluginId));
    }

    @Override
    public List<SelectorData> listAll() {
        return this.buildSelectorDataList(this.selectorMapper.selectAll());
    }

    @EventListener(value={BatchPluginDeletedEvent.class})
    public void onPluginDeleted(BatchPluginDeletedEvent event) {
        this.deleteSelector(this.selectorMapper.findByPluginIds(event.getDeletedPluginIds()), event.getPlugins());
    }

    private void createCondition(String selectorId, List<SelectorConditionDTO> selectorConditions) {
        for (SelectorConditionDTO condition : selectorConditions) {
            condition.setSelectorId(selectorId);
            this.selectorConditionMapper.insertSelective(SelectorConditionDO.buildSelectorConditionDO(condition));
        }
    }

    private int deleteSelector(List<SelectorDO> selectors, List<PluginDO> plugins) {
        if (CollectionUtils.isNotEmpty(selectors)) {
            List selectorIds = ListUtil.map(selectors, BaseDO::getId);
            int count = this.selectorMapper.deleteByIds(selectorIds);
            this.selectorConditionMapper.deleteBySelectorIds(selectorIds);
            if (count > 0) {
                this.selectorEventPublisher.onDeleted(selectors, plugins);
            }
            return count;
        }
        return selectors.size();
    }

    private void publishEvent(SelectorDO selectorDO, List<SelectorConditionDTO> selectorConditions, List<SelectorConditionDO> beforeSelectorCondition) {
        PluginDO pluginDO = this.pluginMapper.selectById(selectorDO.getPluginId());
        List conditionDataList = ListUtil.map(selectorConditions, ConditionTransfer.INSTANCE::mapToSelectorDTO);
        List beforeConditionDataList = ListUtil.map(beforeSelectorCondition, ConditionTransfer.INSTANCE::mapToSelectorDO);
        SelectorData selectorData = SelectorDO.transFrom(selectorDO, pluginDO.getName(), conditionDataList, beforeConditionDataList);
        this.eventPublisher.publishEvent((ApplicationEvent)new DataChangedEvent(ConfigGroupEnum.SELECTOR, DataEventTypeEnum.UPDATE, Collections.singletonList(selectorData)));
    }

    private SelectorData buildSelectorData(SelectorDO selectorDO) {
        List<ConditionData> conditionDataList = ConditionTransfer.INSTANCE.mapToSelectorDOS(this.selectorConditionMapper.selectByQuery(new SelectorConditionQuery(selectorDO.getId())));
        PluginDO pluginDO = this.pluginMapper.selectById(selectorDO.getPluginId());
        if (Objects.isNull(pluginDO)) {
            return null;
        }
        return SelectorDO.transFrom(selectorDO, pluginDO.getName(), conditionDataList);
    }

    private List<SelectorData> buildSelectorDataList(List<SelectorDO> selectorDOList) {
        Map idMap = ListUtil.toMap(selectorDOList, BaseDO::getId, SelectorDO::getPluginId);
        if (MapUtils.isEmpty((Map)idMap)) {
            return new ArrayList<SelectorData>();
        }
        Map selectorConditionMap = ListUtil.groupBy(this.selectorConditionMapper.selectBySelectorIds(idMap.keySet()), SelectorConditionDO::getSelectorId);
        Map pluginDOMap = ListUtil.toMap(this.pluginMapper.selectByIds(Lists.newArrayList(idMap.values())), BaseDO::getId);
        return Optional.ofNullable(selectorDOList).orElseGet(ArrayList::new).stream().filter(Objects::nonNull).map(selectorDO -> {
            String id = selectorDO.getId();
            String pluginId = selectorDO.getPluginId();
            PluginDO pluginDO = (PluginDO)pluginDOMap.get(pluginId);
            if (Objects.isNull(pluginDO)) {
                return null;
            }
            List<ConditionData> conditionDataList = ConditionTransfer.INSTANCE.mapToSelectorDOS((List)selectorConditionMap.get(id));
            return SelectorDO.transFrom(selectorDO, pluginDO.getName(), conditionDataList);
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

