/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.manager.impl;

import com.google.gson.JsonObject;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.model.bean.DocInfo;
import org.apache.shenyu.admin.model.bean.DocItem;
import org.apache.shenyu.admin.model.bean.DocModule;
import org.apache.shenyu.admin.model.bean.UpstreamInstance;
import org.apache.shenyu.admin.service.manager.DocManager;
import org.apache.shenyu.admin.service.manager.DocParser;
import org.apache.shenyu.admin.service.manager.RegisterApiDocService;
import org.apache.shenyu.admin.service.manager.impl.SwaggerDocParser;
import org.apache.shenyu.common.enums.ApiHttpMethodEnum;
import org.apache.shenyu.common.enums.ApiSourceEnum;
import org.apache.shenyu.common.enums.ApiStateEnum;
import org.apache.shenyu.common.enums.RpcTypeEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.common.utils.JsonUtils;
import org.apache.shenyu.register.common.dto.ApiDocRegisterDTO;
import org.apache.shenyu.register.common.enums.EventType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.DigestUtils;

@Service
public class DocManagerImpl
implements DocManager {
    private static final Logger LOG = LoggerFactory.getLogger(DocManagerImpl.class);
    private static final String API_DOC_VERSION = "v0.01";
    private static final String HTTP = "http://";
    private static final Map<String, DocInfo> DOC_DEFINITION_MAP = new HashMap<String, DocInfo>();
    private static final DocParser SWAGGER_DOC_PARSER = new SwaggerDocParser();
    @Resource
    private RegisterApiDocService registerApiDocService;

    @Override
    public void addDocInfo(UpstreamInstance instance, String docInfoJson, String oldMd5, Consumer<DocInfo> callback) {
        if (StringUtils.isEmpty((CharSequence)docInfoJson)) {
            return;
        }
        String newMd5 = DigestUtils.md5DigestAsHex((byte[])docInfoJson.getBytes(StandardCharsets.UTF_8));
        if (Objects.equals(newMd5, oldMd5)) {
            return;
        }
        DocInfo docInfo = this.getDocInfo(instance.getClusterName(), docInfoJson);
        if (Objects.isNull(docInfo) || CollectionUtils.isEmpty(docInfo.getDocModuleList())) {
            return;
        }
        docInfo.setDocMd5(newMd5);
        List<DocModule> docModules = docInfo.getDocModuleList();
        docModules.forEach(docModule -> docModule.getDocItems().forEach(docItem -> {
            ApiDocRegisterDTO build = ApiDocRegisterDTO.builder().consume(this.getProduceConsume(docItem.getConsumes())).produce(this.getProduceConsume(docItem.getProduces())).httpMethod(this.getHttpMethod((DocItem)docItem)).contextPath(docInfo.getContextPath()).ext(this.buildExtJson(instance, (DocItem)docItem)).document(JsonUtils.toJson((Object)docItem)).rpcType(RpcTypeEnum.HTTP.getName()).version(API_DOC_VERSION).apiDesc(docItem.getDescription()).tags(Collections.singletonList(docInfo.getContextPath())).apiPath(docItem.getName()).apiSource(ApiSourceEnum.SWAGGER.getValue()).state(Integer.valueOf(ApiStateEnum.UNPUBLISHED.getState())).apiOwner("admin").eventType(EventType.REGISTER).build();
            this.registerApiDocService.registerApiDocument(build);
        }));
        callback.accept(docInfo);
    }

    private String getProduceConsume(Collection<String> list) {
        Optional<String> first;
        String res = "";
        if (Objects.nonNull(list) && (first = list.stream().findFirst()).isPresent()) {
            res = first.get();
        }
        return StringUtils.isNotEmpty((CharSequence)res) ? res : "*/*";
    }

    private Integer getHttpMethod(DocItem docItem) {
        Integer httpMethod = null;
        Optional<String> first = docItem.getHttpMethodList().stream().findFirst();
        if (first.isPresent()) {
            String method = docItem.getHttpMethodList().size() == 1 ? StringUtils.upperCase((String)first.get()) : ApiHttpMethodEnum.GET.getName();
            httpMethod = ApiHttpMethodEnum.getValueByName((String)method);
        }
        return httpMethod;
    }

    private DocInfo getDocInfo(String clusterName, String docInfoJson) {
        try {
            JsonObject docRoot = (JsonObject)GsonUtils.getInstance().fromJson(docInfoJson, JsonObject.class);
            String contexPath = "/" + clusterName;
            docRoot.addProperty("basePath", contexPath);
            DocInfo docInfo = SWAGGER_DOC_PARSER.parseJson(docRoot);
            docInfo.setClusterName(clusterName);
            docInfo.setContextPath(contexPath);
            return docInfo;
        }
        catch (Exception e) {
            LOG.error("getDocInfo clusterName={} error={} ", (Object)clusterName, (Object)e);
            return null;
        }
    }

    private String buildExtJson(UpstreamInstance instance, DocItem docItem) {
        ApiDocRegisterDTO.ApiExt ext = new ApiDocRegisterDTO.ApiExt();
        ext.setHost(instance.getIp());
        ext.setPort(Integer.valueOf(instance.getPort()));
        ext.setServiceName(instance.getClusterName());
        ext.setMethodName(docItem.getName());
        ext.setParameterTypes("");
        ext.setRpcExt(null);
        ext.setAddPrefixed(false);
        ext.setProtocol(HTTP);
        return GsonUtils.getInstance().toJson((Object)ext);
    }

    @Override
    public Collection<DocInfo> listAll() {
        return DOC_DEFINITION_MAP.values();
    }
}

