/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.manager.impl;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.shenyu.admin.mapper.PluginMapper;
import org.apache.shenyu.admin.model.bean.UpstreamInstance;
import org.apache.shenyu.admin.model.entity.BaseDO;
import org.apache.shenyu.admin.model.entity.PluginDO;
import org.apache.shenyu.admin.model.page.CommonPager;
import org.apache.shenyu.admin.model.page.PageParameter;
import org.apache.shenyu.admin.model.query.SelectorQuery;
import org.apache.shenyu.admin.model.vo.SelectorVO;
import org.apache.shenyu.admin.model.vo.ShenyuDictVO;
import org.apache.shenyu.admin.service.DiscoveryUpstreamService;
import org.apache.shenyu.admin.service.SelectorService;
import org.apache.shenyu.admin.service.ShenyuDictService;
import org.apache.shenyu.admin.service.manager.LoadServiceDocEntry;
import org.apache.shenyu.admin.service.manager.PullSwaggerDocService;
import org.apache.shenyu.common.dto.DiscoverySyncData;
import org.apache.shenyu.common.dto.DiscoveryUpstreamData;
import org.apache.shenyu.common.enums.DataEventTypeEnum;
import org.apache.shenyu.common.enums.RpcTypeEnum;
import org.apache.shenyu.common.utils.JsonUtils;
import org.apache.shenyu.common.utils.PluginNameAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class LoadServiceDocEntryImpl
implements LoadServiceDocEntry {
    private static final Logger LOG = LoggerFactory.getLogger(LoadServiceDocEntryImpl.class);
    private static Set<String> supportSwaggerPluginSet = Collections.emptySet();
    private final SelectorService selectorService;
    private final DiscoveryUpstreamService discoveryUpstreamService;
    private final PluginMapper pluginMapper;
    private final PullSwaggerDocService pullSwaggerDocService;
    private final ShenyuDictService shenyuDictService;

    public LoadServiceDocEntryImpl(SelectorService selectorService, DiscoveryUpstreamService discoveryUpstreamService, PluginMapper pluginMapper, PullSwaggerDocService pullSwaggerDocService, ShenyuDictService shenyuDictService) {
        this.selectorService = selectorService;
        this.discoveryUpstreamService = discoveryUpstreamService;
        this.pluginMapper = pluginMapper;
        this.pullSwaggerDocService = pullSwaggerDocService;
        this.shenyuDictService = shenyuDictService;
    }

    @Override
    public synchronized void loadApiDocument() {
        if (!this.isEnabledLoad()) {
            return;
        }
        List<UpstreamInstance> serviceList = this.getAllClusterLastUpdateInstanceList();
        if (CollectionUtils.isEmpty(serviceList)) {
            LOG.info("load api document No service registered.");
            return;
        }
        HashSet<UpstreamInstance> currentServices = new HashSet<UpstreamInstance>(serviceList);
        LOG.info("load api document, serviceList={}", (Object)JsonUtils.toJson(currentServices));
        this.pullSwaggerDocService.pullApiDocument(currentServices);
    }

    @Override
    public void loadDocOnUpstreamChanged(List<DiscoverySyncData> discoverySyncDataList, DataEventTypeEnum eventType) {
        if (Objects.nonNull(eventType) && (eventType == DataEventTypeEnum.CREATE || eventType == DataEventTypeEnum.UPDATE)) {
            List<UpstreamInstance> serviceList = this.getLastUpdateInstanceList(discoverySyncDataList);
            if (CollectionUtils.isEmpty(serviceList)) {
                LOG.info("load api document, no service registered.");
                return;
            }
            if (!this.isEnabledLoad()) {
                return;
            }
            HashSet<UpstreamInstance> currentServices = new HashSet<UpstreamInstance>(serviceList);
            LOG.info("loadDocOnSelectorChanged, serviceList={}", (Object)JsonUtils.toJson(currentServices));
            this.pullSwaggerDocService.pullApiDocument(currentServices);
        }
    }

    private boolean isEnabledLoad() {
        ShenyuDictVO shenyuInitData = this.shenyuDictService.findByDictCodeName("API_DOC_GLOBAL_FLAG", "status");
        if (Objects.nonNull(shenyuInitData) && Boolean.TRUE.toString().equals(shenyuInitData.getDictValue())) {
            return true;
        }
        LOG.info("load api document global switch is close.");
        return false;
    }

    private List<UpstreamInstance> getLastUpdateInstanceList(List<DiscoverySyncData> discoverySyncDataList) {
        if (CollectionUtils.isEmpty(discoverySyncDataList)) {
            LOG.info("getLastUpdateInstanceList, changedList is empty.");
            return Collections.emptyList();
        }
        return discoverySyncDataList.parallelStream().map(this::getClusterLastUpdateInstance).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private List<UpstreamInstance> getInstances2(List<DiscoveryUpstreamData> discoveryUpstreamDataList, String contextPath) {
        List<Object> allInstances = null;
        if (CollectionUtils.isNotEmpty(discoveryUpstreamDataList)) {
            allInstances = new ArrayList();
            try {
                allInstances = discoveryUpstreamDataList.stream().map(discoveryUpstreamData -> {
                    String[] upstreamUrlArr = discoveryUpstreamData.getUrl().split(":");
                    UpstreamInstance instance = new UpstreamInstance();
                    instance.setContextPath(contextPath);
                    instance.setEnabled(true);
                    instance.setIp(upstreamUrlArr[0]);
                    instance.setPort(upstreamUrlArr.length == 1 ? 80 : Integer.parseInt(upstreamUrlArr[1]));
                    instance.setHealthy(true);
                    Long startupTime = Optional.ofNullable(discoveryUpstreamData.getDateCreated()).map(Timestamp::getTime).orElse(System.currentTimeMillis());
                    instance.setStartupTime(startupTime);
                    return instance;
                }).collect(Collectors.toList());
            }
            catch (Exception e) {
                LOG.error("Error getting cluster instance list. contextPath={} error={}", (Object)contextPath, (Object)e);
                return Collections.emptyList();
            }
        }
        return allInstances;
    }

    private List<UpstreamInstance> getAllClusterLastUpdateInstanceList() {
        List<String> pluginNames = RpcTypeEnum.acquireSupportSwaggers().stream().map(rpcTypeEnum -> PluginNameAdapter.rpcTypeAdapter((String)rpcTypeEnum.getName())).collect(Collectors.toList());
        List<PluginDO> pluginDOList = this.pluginMapper.selectByNames(pluginNames);
        if (CollectionUtils.isEmpty(pluginDOList)) {
            return Collections.emptyList();
        }
        supportSwaggerPluginSet = new HashSet<String>(pluginNames);
        List<String> pluginIds = pluginDOList.stream().map(BaseDO::getId).collect(Collectors.toList());
        CommonPager<SelectorVO> commonPager = this.selectorService.listByPage(new SelectorQuery(pluginIds, null, new PageParameter(1, Integer.MAX_VALUE)));
        List<SelectorVO> clusterList = commonPager.getDataList();
        if (CollectionUtils.isEmpty(clusterList)) {
            LOG.info("getAllClusterLastUpdateInstanceList. Not loaded into available backend services.");
            return Collections.emptyList();
        }
        return clusterList.parallelStream().map(this::getClusterLastUpdateInstance).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private UpstreamInstance getClusterLastUpdateInstance(SelectorVO selectorVO) {
        List<UpstreamInstance> allInstances = this.getInstances(selectorVO.getId(), selectorVO.getName(), selectorVO.getEnabled());
        if (CollectionUtils.isEmpty(allInstances)) {
            return null;
        }
        return this.getClusterLastUpdateInstance(allInstances);
    }

    private UpstreamInstance getClusterLastUpdateInstance(DiscoverySyncData discoverySyncData) {
        if (!supportSwaggerPluginSet.contains(discoverySyncData.getPluginName())) {
            LOG.info("getClusterLastUpdateInstance. pluginName={} does not support pulling API documents.", (Object)discoverySyncData.getPluginName());
            return null;
        }
        List<UpstreamInstance> allInstances = this.getInstances2(discoverySyncData.getUpstreamDataList(), discoverySyncData.getSelectorName());
        if (Objects.isNull(allInstances)) {
            return null;
        }
        return this.getClusterLastUpdateInstance(allInstances);
    }

    private UpstreamInstance getClusterLastUpdateInstance(List<UpstreamInstance> allInstances) {
        if (CollectionUtils.isEmpty(allInstances)) {
            return null;
        }
        return allInstances.stream().filter(Objects::nonNull).filter(UpstreamInstance::isHealthy).max(Comparator.comparing(UpstreamInstance::getStartupTime)).orElse(null);
    }

    private List<UpstreamInstance> getInstances(String selectorId, String contextPath, boolean enabled) {
        List<Object> allInstances = null;
        List<DiscoveryUpstreamData> discoveryUpstreamDataList = this.discoveryUpstreamService.findBySelectorId(selectorId);
        if (CollectionUtils.isNotEmpty(discoveryUpstreamDataList)) {
            allInstances = new ArrayList();
            try {
                allInstances = discoveryUpstreamDataList.stream().map(discoveryUpstreamData -> {
                    String[] upstreamUrlArr = discoveryUpstreamData.getUrl().split(":");
                    UpstreamInstance instance = new UpstreamInstance();
                    instance.setContextPath(contextPath);
                    instance.setEnabled(enabled);
                    instance.setIp(upstreamUrlArr[0]);
                    instance.setPort(upstreamUrlArr.length == 1 ? 80 : Integer.parseInt(upstreamUrlArr[1]));
                    instance.setHealthy(true);
                    Long startupTime = Optional.ofNullable(discoveryUpstreamData.getDateCreated()).map(Timestamp::getTime).orElse(System.currentTimeMillis());
                    instance.setStartupTime(startupTime);
                    return instance;
                }).collect(Collectors.toList());
            }
            catch (Exception e) {
                LOG.error("Error getting cluster instance list. contextPath={} error={}", (Object)contextPath, (Object)e);
                return Collections.emptyList();
            }
        }
        return allInstances;
    }
}

