/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.manager.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.shenyu.admin.model.dto.ApiDTO;
import org.apache.shenyu.admin.model.dto.TagDTO;
import org.apache.shenyu.admin.model.vo.TagVO;
import org.apache.shenyu.admin.service.ApiService;
import org.apache.shenyu.admin.service.TagService;
import org.apache.shenyu.admin.service.manager.RegisterApiDocService;
import org.apache.shenyu.common.utils.UUIDUtils;
import org.apache.shenyu.register.common.dto.ApiDocRegisterDTO;
import org.apache.shenyu.register.common.enums.EventType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class RegisterApiDocServiceImpl
implements RegisterApiDocService {
    private static final Logger LOG = LoggerFactory.getLogger(RegisterApiDocServiceImpl.class);
    @Resource
    private ApiService apiService;
    @Resource
    private TagService tagService;

    @Override
    public void registerApiDocument(ApiDocRegisterDTO apiDocRegisterDTO) {
        if (apiDocRegisterDTO.getEventType().equals((Object)EventType.REGISTER)) {
            ApiDTO apiDTO = this.buildApiDTO(apiDocRegisterDTO);
            this.apiService.deleteByApiPathHttpMethodRpcType(apiDTO.getApiPath(), apiDTO.getHttpMethod(), apiDTO.getRpcType());
            ArrayList<String> tagsIds = new ArrayList<String>();
            List tags = Collections.singletonList(apiDocRegisterDTO.getContextPath());
            if (CollectionUtils.isNotEmpty((Collection)apiDocRegisterDTO.getTags())) {
                tags = apiDocRegisterDTO.getTags();
            }
            for (String tag : tags) {
                List<TagVO> byQuery = this.tagService.findByQuery(tag);
                if (CollectionUtils.isNotEmpty(byQuery)) {
                    tagsIds.addAll(byQuery.stream().map(TagVO::getId).collect(Collectors.toList()));
                    continue;
                }
                TagDTO tagDTO = new TagDTO();
                String id = UUIDUtils.getInstance().generateShortUuid();
                tagDTO.setTagDesc(tag);
                tagDTO.setName(tag);
                tagDTO.setId(id);
                this.tagService.createRootTag(tagDTO, null);
                tagsIds.add(id);
            }
            apiDTO.setTagIds(tagsIds);
            this.apiService.createOrUpdate(apiDTO);
        } else if (apiDocRegisterDTO.getEventType().equals((Object)EventType.OFFLINE)) {
            String contextPath = apiDocRegisterDTO.getContextPath();
            this.apiService.offlineByContextPath(contextPath);
        }
    }

    private ApiDTO buildApiDTO(ApiDocRegisterDTO apiDocRegisterDTO) {
        ApiDTO apiDTO = new ApiDTO();
        apiDTO.setApiPath(apiDocRegisterDTO.getApiPath());
        apiDTO.setApiSource(apiDocRegisterDTO.getApiSource());
        apiDTO.setApiOwner(apiDocRegisterDTO.getApiOwner());
        apiDTO.setDocument(apiDocRegisterDTO.getDocument());
        apiDTO.setExt(apiDocRegisterDTO.getExt());
        apiDTO.setVersion(apiDocRegisterDTO.getVersion());
        apiDTO.setRpcType(apiDocRegisterDTO.getRpcType());
        apiDTO.setConsume(apiDocRegisterDTO.getConsume());
        apiDTO.setProduce(apiDocRegisterDTO.getProduce());
        apiDTO.setContextPath(apiDocRegisterDTO.getContextPath());
        apiDTO.setHttpMethod(apiDocRegisterDTO.getHttpMethod());
        apiDTO.setState(apiDocRegisterDTO.getState());
        apiDTO.setApiDesc(apiDocRegisterDTO.getApiDesc());
        return apiDTO;
    }
}

