/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.register;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.shenyu.admin.model.entity.MetaDataDO;
import org.apache.shenyu.admin.model.entity.SelectorDO;
import org.apache.shenyu.admin.service.MetaDataService;
import org.apache.shenyu.admin.service.register.AbstractContextPathRegisterService;
import org.apache.shenyu.admin.utils.CommonUpstreamUtils;
import org.apache.shenyu.common.dto.convert.rule.impl.WebSocketRuleHandle;
import org.apache.shenyu.common.dto.convert.selector.WebSocketUpstream;
import org.apache.shenyu.common.enums.RpcTypeEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.register.common.dto.MetaDataRegisterDTO;
import org.apache.shenyu.register.common.dto.URIRegisterDTO;
import org.springframework.stereotype.Service;

@Service
public class ShenyuClientRegisterWebSocketServiceImpl
extends AbstractContextPathRegisterService {
    @Override
    public String rpcType() {
        return RpcTypeEnum.WEB_SOCKET.getName();
    }

    @Override
    protected String selectorHandler(MetaDataRegisterDTO metaDataDTO) {
        return "";
    }

    @Override
    protected String ruleHandler() {
        return new WebSocketRuleHandle().toJson();
    }

    @Override
    protected void registerMetadata(MetaDataRegisterDTO dto) {
        if (dto.isRegisterMetaData()) {
            MetaDataService metaDataService = this.getMetaDataService();
            MetaDataDO exist = metaDataService.findByPath(dto.getPath());
            metaDataService.saveOrUpdateMetaData(exist, dto);
        }
    }

    @Override
    protected String buildHandle(List<URIRegisterDTO> uriList, SelectorDO selectorDO) {
        String handleAdd;
        List<WebSocketUpstream> addList = this.buildWebSocketUpstreamList(uriList);
        List<Object> canAddList = new CopyOnWriteArrayList();
        List existList = GsonUtils.getInstance().fromCurrentList(selectorDO.getHandle(), WebSocketUpstream.class);
        if (CollectionUtils.isEmpty((Collection)existList)) {
            handleAdd = GsonUtils.getInstance().toJson(addList);
            canAddList = addList;
        } else {
            List diffList = addList.stream().filter(divideUpstream -> !existList.contains(divideUpstream)).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(diffList)) {
                canAddList.addAll(diffList);
                existList.addAll(diffList);
            }
            handleAdd = GsonUtils.getInstance().toJson((Object)existList);
        }
        this.doSubmit(selectorDO.getId(), canAddList);
        return handleAdd;
    }

    private List<WebSocketUpstream> buildWebSocketUpstreamList(List<URIRegisterDTO> uriList) {
        return uriList.stream().map(dto -> CommonUpstreamUtils.buildWebSocketUpstream(dto.getProtocol(), dto.getHost(), dto.getPort())).collect(Collectors.toCollection(CopyOnWriteArrayList::new));
    }
}

