/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.client.grpc.server;

import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.ServerServiceDefinition;
import java.io.IOException;
import java.util.List;
import org.apache.shenyu.client.grpc.GrpcClientEventListener;
import org.apache.shenyu.client.grpc.server.GrpcServerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

public class GrpcServerRunner
implements ApplicationListener<ContextRefreshedEvent> {
    private static final Logger LOG = LoggerFactory.getLogger(GrpcServerRunner.class);
    private final GrpcServerBuilder grpcServerBuilder;
    private final GrpcClientEventListener grpcClientEventListener;

    public GrpcServerRunner(GrpcServerBuilder grpcServerBuilder, GrpcClientEventListener grpcClientEventListener) {
        this.grpcServerBuilder = grpcServerBuilder;
        this.grpcClientEventListener = grpcClientEventListener;
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        this.startGrpcServer();
    }

    private void startGrpcServer() {
        ServerBuilder<?> serverBuilder = this.grpcServerBuilder.buildServerBuilder();
        List<ServerServiceDefinition> serviceDefinitions = this.grpcClientEventListener.getServiceDefinitions();
        for (ServerServiceDefinition serviceDefinition : serviceDefinitions) {
            serverBuilder.addService(serviceDefinition);
            LOG.info("{} has been add to grpc server", (Object)serviceDefinition.getServiceDescriptor().getName());
        }
        try {
            Server server = serverBuilder.build().start();
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                LOG.info("shutting down grpc server");
                server.shutdown();
                LOG.info("grpc server shut down");
            }));
            LOG.info("Grpc server started successfully");
        }
        catch (IOException e) {
            LOG.error("Grpc server failed to start", (Throwable)e);
        }
    }
}

