/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.client.motan;

import com.weibo.api.motan.config.springsupport.BasicServiceConfigBean;
import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.shenyu.client.core.client.AbstractContextRefreshedEventListener;
import org.apache.shenyu.client.core.disruptor.ShenyuClientRegisterEventPublisher;
import org.apache.shenyu.client.core.exception.ShenyuClientIllegalArgumentException;
import org.apache.shenyu.client.motan.common.annotation.ShenyuMotanClient;
import org.apache.shenyu.client.motan.common.dto.MotanRpcExt;
import org.apache.shenyu.common.enums.ApiHttpMethodEnum;
import org.apache.shenyu.common.enums.RpcTypeEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.common.utils.IpUtils;
import org.apache.shenyu.register.client.api.ShenyuClientRegisterRepository;
import org.apache.shenyu.register.common.config.PropertiesConfig;
import org.apache.shenyu.register.common.dto.MetaDataRegisterDTO;
import org.apache.shenyu.register.common.dto.URIRegisterDTO;
import org.apache.shenyu.register.common.type.DataTypeParent;
import org.javatuples.Sextet;
import org.springframework.context.ApplicationContext;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.util.ReflectionUtils;

public class MotanServiceEventListener
extends AbstractContextRefreshedEventListener<Object, ShenyuMotanClient> {
    private static final String BASE_SERVICE_CONFIG = "baseServiceConfig";
    private final LocalVariableTableParameterNameDiscoverer localVariableTableParameterNameDiscoverer = new LocalVariableTableParameterNameDiscoverer();
    private final ShenyuClientRegisterEventPublisher publisher = ShenyuClientRegisterEventPublisher.getInstance();
    private ApplicationContext applicationContext;
    private String group;

    public MotanServiceEventListener(PropertiesConfig clientConfig, ShenyuClientRegisterRepository shenyuClientRegisterRepository) {
        super(clientConfig, shenyuClientRegisterRepository);
    }

    protected Sextet<String[], String, String, ApiHttpMethodEnum[], RpcTypeEnum, String> buildApiDocSextet(Method method, Annotation annotation, Map<String, Object> beans) {
        ShenyuMotanClient shenyuMotanClient = (ShenyuMotanClient)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, ShenyuMotanClient.class);
        if (Objects.isNull(shenyuMotanClient)) {
            return null;
        }
        String produce = "*/*";
        String consume = "*/*";
        String[] values = new String[]{shenyuMotanClient.value()};
        ApiHttpMethodEnum[] apiHttpMethodEnums = new ApiHttpMethodEnum[]{ApiHttpMethodEnum.NOT_HTTP};
        String version = "v0.01";
        return Sextet.with((Object)values, (Object)consume, (Object)produce, (Object)apiHttpMethodEnums, (Object)RpcTypeEnum.MOTAN, (Object)version);
    }

    protected Map<String, Object> getBeans(ApplicationContext context) {
        this.applicationContext = context;
        this.group = ((BasicServiceConfigBean)this.applicationContext.getBean(BASE_SERVICE_CONFIG)).getGroup();
        return context.getBeansWithAnnotation(ShenyuMotanClient.class);
    }

    protected URIRegisterDTO buildURIRegisterDTO(ApplicationContext context, Map<String, Object> beans) {
        return URIRegisterDTO.builder().contextPath(this.getContextPath()).appName(this.getAppName()).rpcType(RpcTypeEnum.MOTAN.getName()).host(this.getHost()).port(Integer.valueOf(Integer.parseInt(this.getPort()))).build();
    }

    protected String buildApiSuperPath(Class<?> clazz, ShenyuMotanClient shenyuMotanClient) {
        if (Objects.nonNull(shenyuMotanClient) && !StringUtils.isBlank((CharSequence)shenyuMotanClient.path())) {
            return shenyuMotanClient.path();
        }
        return "";
    }

    protected Class<ShenyuMotanClient> getAnnotationType() {
        return ShenyuMotanClient.class;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected MetaDataRegisterDTO buildMetaDataDTO(Object bean, ShenyuMotanClient shenyuMotanClient, String superPath, Class<?> clazz, Method method) {
        String serviceName;
        Integer timeout = Optional.ofNullable(((BasicServiceConfigBean)this.applicationContext.getBean(BASE_SERVICE_CONFIG)).getRequestTimeout()).orElse(1000);
        MotanService service = (MotanService)AnnotatedElementUtils.findMergedAnnotation(clazz, MotanService.class);
        String path = superPath.contains("*") ? this.pathJoin(new String[]{this.getContextPath(), superPath.replace("*", ""), method.getName()}) : this.pathJoin(new String[]{this.getContextPath(), superPath, shenyuMotanClient.path()});
        String desc = shenyuMotanClient.desc();
        String host = IpUtils.isCompleteHost((String)this.getHost()) ? this.getHost() : IpUtils.getHost((String)this.getHost());
        int port = StringUtils.isBlank((CharSequence)this.getPort()) ? -1 : Integer.parseInt(this.getPort());
        String configRuleName = shenyuMotanClient.ruleName();
        String ruleName = "".equals(configRuleName) ? path : configRuleName;
        String methodName = method.getName();
        Class<?>[] parameterTypesClazz = method.getParameterTypes();
        String parameterTypes = Arrays.stream(parameterTypesClazz).map(Class::getName).collect(Collectors.joining(","));
        if (Void.TYPE.equals(service.interfaceClass())) {
            if (clazz.getInterfaces().length <= 0) throw new ShenyuClientIllegalArgumentException("Failed to export remote service class " + clazz.getName() + ", cause: The @Service undefined interfaceClass or interfaceName, and the service class unimplemented any interfaces.");
            serviceName = clazz.getInterfaces()[0].getName();
            return MetaDataRegisterDTO.builder().appName(this.getAppName()).serviceName(serviceName).methodName(methodName).contextPath(this.getContextPath()).path(path).port(Integer.valueOf(port)).host(host).ruleName(ruleName).pathDesc(desc).parameterTypes(parameterTypes).rpcType(RpcTypeEnum.MOTAN.getName()).rpcExt(this.buildRpcExt(method, timeout)).enabled(shenyuMotanClient.enabled()).build();
        } else {
            serviceName = service.interfaceClass().getName();
        }
        return MetaDataRegisterDTO.builder().appName(this.getAppName()).serviceName(serviceName).methodName(methodName).contextPath(this.getContextPath()).path(path).port(Integer.valueOf(port)).host(host).ruleName(ruleName).pathDesc(desc).parameterTypes(parameterTypes).rpcType(RpcTypeEnum.MOTAN.getName()).rpcExt(this.buildRpcExt(method, timeout)).enabled(shenyuMotanClient.enabled()).build();
    }

    protected String buildApiPath(Method method, String superPath, ShenyuMotanClient methodShenyuClient) {
        return superPath.contains("*") ? this.pathJoin(new String[]{this.getContextPath(), superPath.replace("*", ""), method.getName()}) : this.pathJoin(new String[]{this.getContextPath(), superPath, methodShenyuClient.path()});
    }

    protected void handleClass(Class<?> clazz, Object bean, ShenyuMotanClient beanShenyuClient, String superPath) {
        Method[] methods;
        for (Method method : methods = ReflectionUtils.getDeclaredMethods(clazz)) {
            this.publisher.publishEvent((DataTypeParent)this.buildMetaDataDTO(bean, beanShenyuClient, superPath, clazz, method));
        }
    }

    private MotanRpcExt.RpcExt buildRpcExt(Method method) {
        String[] paramNames = this.localVariableTableParameterNameDiscoverer.getParameterNames(method);
        ArrayList<Pair<String, String>> params = new ArrayList<Pair<String, String>>();
        if (paramNames != null && paramNames.length > 0) {
            Class<?>[] paramTypes = method.getParameterTypes();
            for (int i = 0; i < paramNames.length; ++i) {
                params.add((Pair<String, String>)Pair.of((Object)paramTypes[i].getName(), (Object)paramNames[i]));
            }
        }
        return new MotanRpcExt.RpcExt(method.getName(), params);
    }

    private String buildRpcExt(Method method, Integer timeout) {
        ArrayList<MotanRpcExt.RpcExt> list = new ArrayList<MotanRpcExt.RpcExt>();
        list.add(this.buildRpcExt(method));
        MotanRpcExt buildList = new MotanRpcExt(list, this.group, timeout);
        return GsonUtils.getInstance().toJson((Object)buildList);
    }
}

