/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.discovery.zookeeper;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.TreeCache;
import org.apache.curator.framework.recipes.cache.TreeCacheListener;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.shenyu.common.exception.ShenyuException;
import org.apache.shenyu.discovery.api.ShenyuDiscoveryService;
import org.apache.shenyu.discovery.api.config.DiscoveryConfig;
import org.apache.shenyu.discovery.api.listener.DataChangedEventListener;
import org.apache.shenyu.discovery.api.listener.DiscoveryDataChangedEvent;
import org.apache.shenyu.spi.Join;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Join
public class ZookeeperDiscoveryService
implements ShenyuDiscoveryService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZookeeperDiscoveryService.class);
    private CuratorFramework client;
    private final Map<String, String> nodeDataMap = new HashMap<String, String>();
    private final Map<String, TreeCache> cacheMap = new HashMap<String, TreeCache>();

    public void init(DiscoveryConfig config) {
        if (this.client != null) {
            LOGGER.info("ZooKeeper naming service already registered");
            return;
        }
        String baseSleepTimeMilliseconds = config.getProps().getProperty("baseSleepTimeMilliseconds", "1000");
        String maxRetries = config.getProps().getProperty("maxRetries", "3");
        String maxSleepTimeMilliseconds = config.getProps().getProperty("maxSleepTimeMilliseconds", "1000");
        String connectionTimeoutMilliseconds = config.getProps().getProperty("connectionTimeoutMilliseconds", "1000");
        String sessionTimeoutMilliseconds = config.getProps().getProperty("sessionTimeoutMilliseconds", "1000");
        String namespace = config.getProps().getProperty("namespace", "");
        String digest = config.getProps().getProperty("digest", null);
        ExponentialBackoffRetry retryPolicy = new ExponentialBackoffRetry(Integer.parseInt(baseSleepTimeMilliseconds), Integer.parseInt(maxRetries), Integer.parseInt(maxSleepTimeMilliseconds));
        CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder().connectString(config.getServerList()).retryPolicy((RetryPolicy)retryPolicy).connectionTimeoutMs(Integer.parseInt(connectionTimeoutMilliseconds)).sessionTimeoutMs(Integer.parseInt(sessionTimeoutMilliseconds)).namespace(namespace);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{digest})) {
            builder.authorization("digest", digest.getBytes(StandardCharsets.UTF_8));
        }
        this.client = builder.build();
        this.start();
    }

    private void start() {
        this.client.getConnectionStateListenable().addListener((c, newState) -> {
            if (newState == ConnectionState.RECONNECTED) {
                this.nodeDataMap.forEach((k, v) -> {
                    if (!this.exists((String)k).booleanValue()) {
                        this.createOrUpdate((String)k, (String)v, CreateMode.EPHEMERAL);
                        LOGGER.info("zookeeper client register instance success: key={}|value={}", k, v);
                    }
                });
            }
        });
        this.client.start();
        try {
            if (!this.client.blockUntilConnected(30, TimeUnit.SECONDS)) {
                throw new ShenyuException("shenyu start ZookeeperDiscoveryService failure 30 seconds timeout");
            }
        }
        catch (InterruptedException e) {
            throw new ShenyuException((Throwable)e);
        }
    }

    public Boolean exists(String key) {
        try {
            return null != this.client.checkExists().forPath(key);
        }
        catch (Exception e) {
            throw new ShenyuException((Throwable)e);
        }
    }

    private void createOrUpdate(String key, String value, CreateMode mode) {
        String val = StringUtils.isEmpty((CharSequence)value) ? "" : value;
        try {
            ((ACLBackgroundPathAndBytesable)this.client.create().orSetData().creatingParentsIfNeeded().withMode(mode)).forPath(key, val.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            throw new ShenyuException((Throwable)e);
        }
    }

    public void watch(String key, DataChangedEventListener listener) {
        try {
            TreeCache treeCache = new TreeCache(this.client, key);
            TreeCacheListener treeCacheListener = (curatorFramework, event) -> {
                ChildData data = event.getData();
                if (Objects.nonNull(data) && Objects.nonNull(data.getData())) {
                    DiscoveryDataChangedEvent dataChangedEvent;
                    boolean isEphemeral;
                    String currentPath = data.getPath();
                    String currentData = new String(data.getData(), StandardCharsets.UTF_8);
                    LOGGER.info("shenyu find resultData ={}", (Object)currentData);
                    Stat stat = data.getStat();
                    boolean bl = isEphemeral = Objects.nonNull(stat) && stat.getEphemeralOwner() > 0L;
                    if (!isEphemeral) {
                        LOGGER.info("shenyu Ignore non-ephemeral node changes");
                        return;
                    }
                    switch (event.getType()) {
                        case NODE_ADDED: {
                            dataChangedEvent = new DiscoveryDataChangedEvent(currentPath, currentData, DiscoveryDataChangedEvent.Event.ADDED);
                            break;
                        }
                        case NODE_UPDATED: {
                            dataChangedEvent = new DiscoveryDataChangedEvent(currentPath, currentData, DiscoveryDataChangedEvent.Event.UPDATED);
                            break;
                        }
                        case NODE_REMOVED: {
                            dataChangedEvent = new DiscoveryDataChangedEvent(currentPath, currentData, DiscoveryDataChangedEvent.Event.DELETED);
                            break;
                        }
                        default: {
                            dataChangedEvent = new DiscoveryDataChangedEvent(currentPath, currentData, DiscoveryDataChangedEvent.Event.IGNORED);
                        }
                    }
                    listener.onChange(dataChangedEvent);
                }
            };
            treeCache.getListenable().addListener((Object)treeCacheListener);
            treeCache.start();
            this.cacheMap.put(key, treeCache);
        }
        catch (Exception e) {
            throw new ShenyuException((Throwable)e);
        }
    }

    public void unwatch(String key) {
        if (this.cacheMap.containsKey(key)) {
            this.cacheMap.remove(key).close();
        }
    }

    public void register(String key, String value) {
        String seqPath = key + "/seq_";
        this.createOrUpdate(seqPath, value, CreateMode.EPHEMERAL_SEQUENTIAL);
    }

    public List<String> getRegisterData(String key) {
        try {
            List children = (List)this.client.getChildren().forPath(key);
            ArrayList<String> datas = new ArrayList<String>();
            for (String child : children) {
                String nodePath = key + "/" + child;
                byte[] data = (byte[])this.client.getData().forPath(nodePath);
                datas.add(new String(data, StandardCharsets.UTF_8));
            }
            return datas;
        }
        catch (Exception e) {
            throw new ShenyuException((Throwable)e);
        }
    }

    public void shutdown() {
        try {
            for (String key : this.cacheMap.keySet()) {
                this.cacheMap.get(key).close();
            }
            this.client.close();
            this.client = null;
            LOGGER.info("Shutting down ZookeeperDiscoveryService");
        }
        catch (Exception e) {
            throw new ShenyuException((Throwable)e);
        }
    }
}

