/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.disruptor.provider;

import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.dsl.Disruptor;
import java.util.function.Consumer;
import org.apache.shenyu.disruptor.event.DataEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisruptorProvider<T> {
    private final RingBuffer<DataEvent<T>> ringBuffer;
    private final Disruptor<DataEvent<T>> disruptor;
    private Logger logger = LoggerFactory.getLogger(DisruptorProvider.class);

    public DisruptorProvider(RingBuffer<DataEvent<T>> ringBuffer, Disruptor<DataEvent<T>> disruptor) {
        this.ringBuffer = ringBuffer;
        this.disruptor = disruptor;
    }

    public void onData(Consumer<DataEvent<T>> function) {
        long position = this.ringBuffer.next();
        try {
            DataEvent dataEvent = (DataEvent)this.ringBuffer.get(position);
            function.accept(dataEvent);
            this.ringBuffer.publish(position);
        }
        catch (Exception ex) {
            this.logger.error("ex", (Throwable)ex);
        }
    }

    public void shutdown() {
        if (null != this.disruptor) {
            this.disruptor.shutdown();
        }
    }
}

