/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.brpc.cache;

import com.baidu.cloud.starlight.api.rpc.StarlightClient;
import com.baidu.cloud.starlight.api.rpc.config.ServiceConfig;
import com.baidu.cloud.starlight.api.rpc.config.TransportConfig;
import com.baidu.cloud.starlight.core.rpc.SingleStarlightClient;
import com.baidu.cloud.starlight.core.rpc.generic.AsyncGenericService;
import com.baidu.cloud.starlight.core.rpc.proxy.JDKProxyFactory;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.shenyu.common.dto.MetaData;
import org.apache.shenyu.common.dto.convert.plugin.BrpcRegisterConfig;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.plugin.brpc.exception.ShenyuBrpcPluginException;
import org.apache.shenyu.plugin.brpc.util.ProxyInfoUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;

public final class ApplicationConfigCache {
    public static final ConcurrentMap<String, BrpcParamInfo> PARAM_MAP = new ConcurrentHashMap<String, BrpcParamInfo>();
    private static final String BRPC_PROTOCOL = "brpc";
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationConfigCache.class);
    private StarlightClient clientConfig;
    private JDKProxyFactory proxyFactory;
    private final LoadingCache<String, AsyncGenericService> cache = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new CacheLoader<String, AsyncGenericService>(){

        public AsyncGenericService load(@NonNull String key) {
            return null;
        }
    });

    private ApplicationConfigCache() {
    }

    public AsyncGenericService initService(MetaData metaData) {
        try {
            AsyncGenericService service = (AsyncGenericService)this.cache.get((Object)metaData.getPath());
            if (Objects.nonNull(service)) {
                return service;
            }
        }
        catch (Exception e) {
            LOG.warn("init brpc ref ex:{}", (Object)e.getMessage());
        }
        return this.build(metaData);
    }

    public void init(BrpcRegisterConfig brpcRegisterConfig) {
        if (Objects.isNull(this.clientConfig)) {
            TransportConfig config = new TransportConfig();
            this.clientConfig = new SingleStarlightClient(brpcRegisterConfig.getAddress(), brpcRegisterConfig.getPort(), config);
            this.clientConfig.init();
            this.proxyFactory = new JDKProxyFactory();
        }
    }

    public AsyncGenericService build(MetaData metaData) {
        if (Objects.isNull(this.clientConfig)) {
            throw new UnsupportedOperationException("unsupport!!");
        }
        ServiceConfig serviceConfig = new ServiceConfig();
        serviceConfig.setProtocol(BRPC_PROTOCOL);
        serviceConfig.setServiceId(metaData.getServiceName());
        BrpcParamExtInfo brpcParamExtInfo = (BrpcParamExtInfo)GsonUtils.getInstance().fromJson(metaData.getRpcExt(), BrpcParamExtInfo.class);
        brpcParamExtInfo.getMethodInfo().forEach(methodInfo -> {
            if (CollectionUtils.isNotEmpty(methodInfo.getParamTypes())) {
                try {
                    Class[] paramTypes = new Class[methodInfo.getParamTypes().size()];
                    String[] paramNames = new String[methodInfo.getParamTypes().size()];
                    for (int i = 0; i < methodInfo.getParamTypes().size(); ++i) {
                        Pair<String, String> pair = methodInfo.getParamTypes().get(i);
                        paramTypes[i] = ProxyInfoUtil.getParamClass((String)pair.getKey());
                        paramNames[i] = (String)pair.getValue();
                        PARAM_MAP.put(methodInfo.getMethodName(), new BrpcParamInfo(paramTypes, paramNames));
                    }
                }
                catch (Exception e) {
                    LOG.error("failed to init brpc, {}", (Object)e.getMessage());
                    throw new ShenyuBrpcPluginException(e.getCause());
                }
            }
        });
        AsyncGenericService service = (AsyncGenericService)this.proxyFactory.getProxy(AsyncGenericService.class, serviceConfig, this.clientConfig);
        this.cache.put((Object)metaData.getPath(), (Object)service);
        return service;
    }

    public AsyncGenericService get(String path) {
        try {
            return (AsyncGenericService)this.cache.get((Object)path);
        }
        catch (ExecutionException e) {
            throw new ShenyuBrpcPluginException(e.getCause());
        }
    }

    public void invalidate(String path) {
        this.cache.invalidate((Object)path);
    }

    public void invalidateAll() {
        this.cache.invalidateAll();
    }

    public static String getClassMethodKey(String className, String methodName) {
        return String.join((CharSequence)"_", className, methodName);
    }

    public StarlightClient getClientConfig() {
        return this.clientConfig;
    }

    public JDKProxyFactory getProxyFactory() {
        return this.proxyFactory;
    }

    public static ApplicationConfigCache getInstance() {
        return ApplicationConfigCacheInstance.INSTANCE;
    }

    public static class BrpcParamInfo {
        private Class<?>[] paramTypes;
        private String[] paramNames;

        BrpcParamInfo(Class<?>[] paramTypes, String[] paramNames) {
            this.paramTypes = paramTypes;
            this.paramNames = paramNames;
        }

        public Class<?>[] getParamTypes() {
            return this.paramTypes;
        }

        public void setParamTypes(Class<?>[] paramTypes) {
            this.paramTypes = paramTypes;
        }

        public String[] getParamNames() {
            return this.paramNames;
        }

        public void setParamNames(String[] paramNames) {
            this.paramNames = paramNames;
        }
    }

    public static class BrpcParamExtInfo {
        private List<MethodInfo> methodInfo;

        public List<MethodInfo> getMethodInfo() {
            return this.methodInfo;
        }

        public void setMethodInfo(List<MethodInfo> methodInfo) {
            this.methodInfo = methodInfo;
        }
    }

    public static class MethodInfo {
        private String methodName;
        private List<Pair<String, String>> paramTypes;

        public String getMethodName() {
            return this.methodName;
        }

        public void setMethodName(String methodName) {
            this.methodName = methodName;
        }

        public List<Pair<String, String>> getParamTypes() {
            return this.paramTypes;
        }

        public void setParamTypes(List<Pair<String, String>> paramTypes) {
            this.paramTypes = paramTypes;
        }
    }

    static final class ApplicationConfigCacheInstance {
        static final ApplicationConfigCache INSTANCE = new ApplicationConfigCache();

        private ApplicationConfigCacheInstance() {
        }
    }
}

