/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.cryptor.request;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.plugin.api.ShenyuPluginChain;
import org.apache.shenyu.plugin.api.exception.ResponsiveException;
import org.apache.shenyu.plugin.api.result.ShenyuResultEnum;
import org.apache.shenyu.plugin.api.utils.WebFluxResultUtils;
import org.apache.shenyu.plugin.base.AbstractShenyuPlugin;
import org.apache.shenyu.plugin.base.utils.CacheKeyUtils;
import org.apache.shenyu.plugin.base.utils.ServerWebExchangeUtils;
import org.apache.shenyu.plugin.cryptor.handler.CryptorRequestPluginDataHandler;
import org.apache.shenyu.plugin.cryptor.handler.CryptorRuleHandler;
import org.apache.shenyu.plugin.cryptor.strategy.CryptorStrategyFactory;
import org.apache.shenyu.plugin.cryptor.utils.CryptorUtil;
import org.apache.shenyu.plugin.cryptor.utils.JsonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class CryptorRequestPlugin
extends AbstractShenyuPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(CryptorRequestPlugin.class);
    private final List<HttpMessageReader<?>> messageReaders;

    public CryptorRequestPlugin(List<HttpMessageReader<?>> messageReaders) {
        this.messageReaders = messageReaders;
    }

    protected Mono<Void> doExecute(ServerWebExchange exchange, ShenyuPluginChain chain, SelectorData selector, RuleData rule) {
        CryptorRuleHandler ruleHandle = (CryptorRuleHandler)CryptorRequestPluginDataHandler.CACHED_HANDLE.get().obtainHandle((Object)CacheKeyUtils.INST.getKey(rule));
        if (Objects.isNull(ruleHandle)) {
            LOG.error("Cryptor request rule configuration is null :{}", (Object)rule.getId());
            return chain.execute(exchange);
        }
        Pair<Boolean, String> pair = CryptorUtil.checkParam(ruleHandle);
        if (Boolean.TRUE.equals(pair.getLeft())) {
            ShenyuResultEnum resultEnum = ShenyuResultEnum.CRYPTOR_REQUEST_ERROR_CONFIGURATION;
            return WebFluxResultUtils.failedResult((int)resultEnum.getCode(), (String)(resultEnum.getMsg() + "[" + (String)pair.getRight() + "]"), (ServerWebExchange)exchange);
        }
        return ServerWebExchangeUtils.rewriteRequestBody((ServerWebExchange)exchange, this.messageReaders, originalBody -> Mono.just((Object)this.convert(ruleHandle, (String)originalBody, exchange))).flatMap(arg_0 -> ((ShenyuPluginChain)chain).execute(arg_0)).onErrorResume(error -> {
            if (error instanceof ResponsiveException) {
                return WebFluxResultUtils.failedResult((ResponsiveException)((ResponsiveException)error));
            }
            return Mono.error((Throwable)error);
        });
    }

    public int getOrder() {
        return PluginEnum.CRYPTOR_REQUEST.getCode();
    }

    public String named() {
        return PluginEnum.CRYPTOR_REQUEST.getName();
    }

    private String convert(CryptorRuleHandler ruleHandle, String originalBody, ServerWebExchange exchange) {
        String parseBody = JsonUtil.parser(originalBody, ruleHandle.getFieldNames());
        if (Objects.isNull(parseBody)) {
            throw new ResponsiveException(ShenyuResultEnum.CRYPTOR_REQUEST_ERROR_CONFIGURATION.getCode(), ShenyuResultEnum.CRYPTOR_REQUEST_ERROR_CONFIGURATION.getMsg() + "[fieldNames]", exchange);
        }
        String modifiedBody = CryptorStrategyFactory.match(ruleHandle, parseBody);
        if (Objects.isNull(modifiedBody)) {
            throw Optional.ofNullable(ruleHandle.getWay()).filter("decrypt"::equals).map(data -> new ResponsiveException(ShenyuResultEnum.DECRYPTION_ERROR, exchange)).orElse(new ResponsiveException(ShenyuResultEnum.ENCRYPTION_ERROR, exchange));
        }
        return CryptorUtil.replace(originalBody, modifiedBody, ruleHandle.getWay(), ruleHandle.getFieldNames());
    }
}

