/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.cryptor.response;

import java.util.Objects;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.plugin.api.ShenyuPluginChain;
import org.apache.shenyu.plugin.api.result.ShenyuResultEnum;
import org.apache.shenyu.plugin.api.result.ShenyuResultWrap;
import org.apache.shenyu.plugin.api.utils.WebFluxResultUtils;
import org.apache.shenyu.plugin.base.AbstractShenyuPlugin;
import org.apache.shenyu.plugin.base.utils.CacheKeyUtils;
import org.apache.shenyu.plugin.cryptor.decorator.CryptorResponseDecorator;
import org.apache.shenyu.plugin.cryptor.handler.CryptorResponsePluginDataHandler;
import org.apache.shenyu.plugin.cryptor.handler.CryptorRuleHandler;
import org.apache.shenyu.plugin.cryptor.utils.CryptorUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class CryptorResponsePlugin
extends AbstractShenyuPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(CryptorResponsePlugin.class);

    protected Mono<Void> doExecute(ServerWebExchange exchange, ShenyuPluginChain chain, SelectorData selector, RuleData rule) {
        CryptorRuleHandler ruleHandle = (CryptorRuleHandler)CryptorResponsePluginDataHandler.CACHED_HANDLE.get().obtainHandle((Object)CacheKeyUtils.INST.getKey(rule));
        if (Objects.isNull(ruleHandle)) {
            LOG.error("Cryptor response rule configuration is null :{}", (Object)rule.getId());
            return chain.execute(exchange);
        }
        Pair<Boolean, String> pair = CryptorUtil.checkParam(ruleHandle);
        if (Boolean.TRUE.equals(pair.getLeft())) {
            Object error = ShenyuResultWrap.error((ServerWebExchange)exchange, (int)ShenyuResultEnum.CRYPTOR_RESPONSE_ERROR_CONFIGURATION.getCode(), (String)(ShenyuResultEnum.CRYPTOR_RESPONSE_ERROR_CONFIGURATION.getMsg() + "[" + (String)pair.getRight() + "]"), null);
            return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)error);
        }
        return chain.execute(exchange.mutate().response((ServerHttpResponse)new CryptorResponseDecorator(exchange, ruleHandle)).build());
    }

    public int getOrder() {
        return PluginEnum.CRYPTOR_RESPONSE.getCode();
    }

    public String named() {
        return PluginEnum.CRYPTOR_RESPONSE.getName();
    }
}

