/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.cryptor.utils;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.shenyu.plugin.api.result.ShenyuResultEnum;
import org.apache.shenyu.plugin.api.result.ShenyuResultWrap;
import org.apache.shenyu.plugin.api.utils.WebFluxResultUtils;
import org.apache.shenyu.plugin.cryptor.handler.CryptorRuleHandler;
import org.apache.shenyu.plugin.cryptor.utils.JsonUtil;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public final class CryptorUtil {
    private CryptorUtil() {
    }

    public static Mono<Void> fail(String mode, ServerWebExchange exchange) {
        Object error = Optional.ofNullable(mode).filter("decrypt"::equals).map(mod -> ShenyuResultWrap.error((ServerWebExchange)exchange, (ShenyuResultEnum)ShenyuResultEnum.DECRYPTION_ERROR)).orElse(ShenyuResultWrap.error((ServerWebExchange)exchange, (ShenyuResultEnum)ShenyuResultEnum.ENCRYPTION_ERROR));
        return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)error);
    }

    public static String replace(String originalBody, String modifiedBody, String way, String fieldNames) {
        if ("decrypt".equals(way)) {
            return modifiedBody;
        }
        AtomicInteger initDeep = new AtomicInteger();
        initDeep.set(0);
        JsonElement je = JsonParser.parseString((String)originalBody);
        JsonElement resultJe = JsonUtil.replaceJsonNode(je, initDeep, modifiedBody, Arrays.asList(fieldNames.split("\\.")));
        return resultJe.toString();
    }

    public static Pair<Boolean, String> checkParam(CryptorRuleHandler ruleHandle) {
        if (StringUtils.isEmpty((CharSequence)ruleHandle.getWay())) {
            return Pair.of((Object)true, (Object)"way");
        }
        if (StringUtils.isEmpty((CharSequence)ruleHandle.getStrategyName())) {
            return Pair.of((Object)true, (Object)"strategyName");
        }
        if (StringUtils.isEmpty((CharSequence)ruleHandle.getFieldNames())) {
            return Pair.of((Object)true, (Object)"fieldNames");
        }
        if (ruleHandle.getWay().equals("decrypt") && StringUtils.isEmpty((CharSequence)ruleHandle.getDecryptKey())) {
            return Pair.of((Object)true, (Object)"decryptKey");
        }
        if (ruleHandle.getWay().equals("encrypt") && StringUtils.isEmpty((CharSequence)ruleHandle.getEncryptKey())) {
            return Pair.of((Object)true, (Object)"encryptKey");
        }
        return Pair.of((Object)false, (Object)"");
    }
}

