/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.mock.api;

import java.util.Map;
import java.util.Objects;
import org.apache.shenyu.common.utils.JsonUtils;

public final class MockRequest {
    private Map<String, String> headers;
    private String uri;
    private String method;
    private Map<String, String> queries;
    private byte[] body;
    private Object json;

    private MockRequest() {
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String getUri() {
        return this.uri;
    }

    public String getMethod() {
        return this.method;
    }

    public Map<String, String> getQueries() {
        return this.queries;
    }

    public Object getJson() {
        if (Objects.isNull(this.json)) {
            this.json = JsonUtils.jsonToMap((String)new String(this.body));
        }
        return this.json;
    }

    public Map<String, String> getForms() {
        throw new UnsupportedOperationException();
    }

    public Object getXml() {
        throw new UnsupportedOperationException();
    }

    static /* synthetic */ byte[] access$502(MockRequest x0, byte[] x1) {
        x0.body = x1;
        return x1;
    }

    public static final class Builder {
        private Map<String, String> headers;
        private String uri;
        private String method;
        private Map<String, String> queries;
        private byte[] body;

        private Builder() {
        }

        public static Builder builder() {
            return new Builder();
        }

        public Builder headers(Map<String, String> headers) {
            this.headers = headers;
            return this;
        }

        public Builder uri(String uri) {
            this.uri = uri;
            return this;
        }

        public Builder method(String method) {
            this.method = method;
            return this;
        }

        public Builder queries(Map<String, String> queries) {
            this.queries = queries;
            return this;
        }

        public Builder body(byte[] body) {
            this.body = body;
            return this;
        }

        public MockRequest build() {
            MockRequest mockRequest = new MockRequest();
            mockRequest.uri = this.uri;
            mockRequest.method = this.method;
            mockRequest.queries = this.queries;
            mockRequest.headers = this.headers;
            MockRequest.access$502(mockRequest, this.body);
            return mockRequest;
        }
    }
}

