/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.register.client.http;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import java.util.List;
import org.apache.shenyu.register.client.api.ShenyuClientRegisterRepository;
import org.apache.shenyu.register.client.http.utils.RegisterUtils;
import org.apache.shenyu.register.common.config.ShenyuRegisterCenterConfig;
import org.apache.shenyu.register.common.dto.MetaDataRegisterDTO;
import org.apache.shenyu.register.common.dto.URIRegisterDTO;
import org.apache.shenyu.spi.Join;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Join
public class HttpClientRegisterRepository
implements ShenyuClientRegisterRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(RegisterUtils.class);
    private static final String META_PATH = "/shenyu-client/register-metadata";
    private static final String URI_PATH = "/shenyu-client/register-uri";
    private List<String> serverList;
    private Gson gson = new Gson();

    public void init(ShenyuRegisterCenterConfig config) {
        this.serverList = Lists.newArrayList((Iterable)Splitter.on((String)",").split((CharSequence)config.getServerLists()));
    }

    public void persistURI(URIRegisterDTO registerDTO) {
        this.doRegister(registerDTO, URI_PATH, "uri");
    }

    public void persistInterface(MetaDataRegisterDTO metadata) {
        this.doRegister(metadata, META_PATH, "metadata");
    }

    private <T> void doRegister(T t, String path, String type) {
        for (String server : this.serverList) {
            try {
                RegisterUtils.doRegister(this.gson.toJson(t), server + path, type);
                return;
            }
            catch (Exception e) {
                LOGGER.error("register admin url :{} is fail, will retry", (Object)server);
            }
        }
    }
}

