/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.register.client.http.utils;

import com.google.gson.Gson;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;

public final class OkHttpTools {
    private static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private static final OkHttpTools OK_HTTP_TOOLS = new OkHttpTools();
    private static final Gson GSON = new Gson();
    private final OkHttpClient client;

    private OkHttpTools() {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.connectTimeout(10L, TimeUnit.SECONDS);
        builder.readTimeout(10L, TimeUnit.SECONDS);
        builder.writeTimeout(10L, TimeUnit.SECONDS);
        this.client = builder.build();
    }

    public static OkHttpTools getInstance() {
        return OK_HTTP_TOOLS;
    }

    public String post(String url, String json) throws IOException {
        RequestBody body = RequestBody.create((MediaType)JSON, (String)json);
        Request request = new Request.Builder().url(url).post(body).build();
        return this.client.newCall(request).execute().body().string();
    }
}

