/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.register.client.http.utils;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;

public final class OkHttpTools {
    private static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private static final OkHttpTools OK_HTTP_TOOLS = new OkHttpTools();
    private final OkHttpClient client;

    private OkHttpTools() {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.connectTimeout(10L, TimeUnit.SECONDS);
        builder.readTimeout(10L, TimeUnit.SECONDS);
        builder.writeTimeout(10L, TimeUnit.SECONDS);
        this.client = builder.build();
    }

    public static OkHttpTools getInstance() {
        return OK_HTTP_TOOLS;
    }

    public String post(String url, String json) throws IOException {
        RequestBody body = RequestBody.create((MediaType)JSON, (String)json);
        Request request = new Request.Builder().url(url).post(body).build();
        return this.client.newCall(request).execute().body().string();
    }

    public String post(String url, String json, Headers headers) throws IOException {
        RequestBody body = RequestBody.create((MediaType)JSON, (String)json);
        Request request = new Request.Builder().headers(headers).url(url).post(body).build();
        return this.client.newCall(request).execute().body().string();
    }

    public String get(String url, Map<String, Object> query) throws IOException {
        Request.Builder reqBuild = new Request.Builder();
        HttpUrl.Builder urlBuilder = HttpUrl.parse((String)url).newBuilder();
        query.forEach((K, V) -> urlBuilder.addQueryParameter(K, String.valueOf(V)));
        reqBuild.url(urlBuilder.build());
        Request request = reqBuild.build();
        return this.client.newCall(request).execute().body().string();
    }

    public String get(String url, String userName, String passWord) throws IOException {
        Request.Builder reqBuild = new Request.Builder();
        HttpUrl.Builder urlBuilder = HttpUrl.parse((String)url).newBuilder();
        urlBuilder.addQueryParameter("username", userName);
        urlBuilder.addQueryParameter("password", passWord);
        reqBuild.url(urlBuilder.build());
        Request request = reqBuild.build();
        return this.client.newCall(request).execute().body().string();
    }
}

