/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.register.client.nacos;

import com.alibaba.nacos.api.config.ConfigFactory;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.NamingFactory;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.api.naming.pojo.Instance;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.ConcurrentLinkedQueue;
import lombok.Generated;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.register.client.api.ShenyuClientRegisterRepository;
import org.apache.shenyu.register.common.config.ShenyuRegisterCenterConfig;
import org.apache.shenyu.register.common.dto.MetaDataRegisterDTO;
import org.apache.shenyu.register.common.dto.URIRegisterDTO;
import org.apache.shenyu.register.common.path.RegisterPathConstants;
import org.apache.shenyu.spi.Join;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Join
public class NacosClientRegisterRepository
implements ShenyuClientRegisterRepository {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NacosClientRegisterRepository.class);
    private String defaultGroup = "default_group";
    private ConfigService configService;
    private NamingService namingService;
    private final ConcurrentLinkedQueue<String> metadataCache = new ConcurrentLinkedQueue();
    private boolean registerService;

    public void init(ShenyuRegisterCenterConfig config) {
        String serverAddr = config.getServerLists();
        Properties properties = config.getProps();
        Properties nacosProperties = new Properties();
        nacosProperties.put("serverAddr", serverAddr);
        String nameSpace = "nacosNameSpace";
        nacosProperties.put("namespace", properties.getProperty(nameSpace));
        nacosProperties.put("username", properties.getProperty("username", ""));
        nacosProperties.put("password", properties.getProperty("password", ""));
        nacosProperties.put("accessKey", properties.getProperty("accessKey", ""));
        nacosProperties.put("secretKey", properties.getProperty("secretKey", ""));
        this.configService = ConfigFactory.createConfigService((Properties)nacosProperties);
        this.namingService = NamingFactory.createNamingService((Properties)nacosProperties);
    }

    public void close() {
        try {
            this.configService.shutDown();
            this.namingService.shutDown();
        }
        catch (NacosException e) {
            log.error("NacosClientRegisterRepository close error!", (Throwable)e);
        }
    }

    public void persistInterface(MetaDataRegisterDTO metadata) {
        String rpcType = metadata.getRpcType();
        String contextPath = metadata.getContextPath().substring(1);
        String host = metadata.getHost();
        int port = metadata.getPort();
        this.registerService(rpcType, contextPath, host, port, metadata);
        this.registerConfig(rpcType, contextPath, metadata);
    }

    private synchronized void registerService(String rpcType, String contextPath, String host, int port, MetaDataRegisterDTO metadata) {
        if (this.registerService) {
            return;
        }
        this.registerService = true;
        Instance instance = new Instance();
        instance.setEphemeral(true);
        instance.setIp(host);
        instance.setPort(port);
        HashMap<String, String> metadataMap = new HashMap<String, String>();
        metadataMap.put("contextPath", contextPath);
        metadataMap.put("uriMetadata", GsonUtils.getInstance().toJson((Object)URIRegisterDTO.transForm((MetaDataRegisterDTO)metadata)));
        instance.setMetadata(metadataMap);
        String serviceName = RegisterPathConstants.buildServiceInstancePath((String)rpcType);
        this.namingService.registerInstance(serviceName, instance);
        log.info("register service success: {}", (Object)serviceName);
    }

    private synchronized void registerConfig(String rpcType, String contextPath, MetaDataRegisterDTO metadata) {
        this.metadataCache.add(GsonUtils.getInstance().toJson((Object)metadata));
        String configName = RegisterPathConstants.buildServiceConfigPath((String)rpcType, (String)contextPath);
        this.configService.publishConfig(configName, this.defaultGroup, GsonUtils.getInstance().toJson(this.metadataCache));
        log.info("register metadata success: {}", (Object)metadata.getRuleName());
    }
}

