/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.register.common.dto;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.shenyu.register.common.type.DataType;
import org.apache.shenyu.register.common.type.DataTypeParent;

public class MetaDataRegisterDTO
implements DataTypeParent {
    private String appName;
    private String contextPath;
    private String path;
    private String pathDesc;
    private String rpcType;
    private String serviceName;
    private String methodName;
    private String ruleName;
    private String parameterTypes;
    private String rpcExt;
    private boolean enabled;
    private String host;
    private Integer port;
    private List<String> pluginNames;
    private boolean registerMetaData;
    private long timeMillis;
    private boolean addPrefixed;

    public MetaDataRegisterDTO(String appName, String contextPath, String path, String pathDesc, String rpcType, String serviceName, String methodName, String ruleName, String parameterTypes, String rpcExt, boolean enabled, String host, Integer port, List<String> pluginNames, boolean registerMetaData, boolean addPrefixed) {
        this.appName = appName;
        this.contextPath = contextPath;
        this.path = path;
        this.pathDesc = pathDesc;
        this.rpcType = rpcType;
        this.serviceName = serviceName;
        this.methodName = methodName;
        this.ruleName = ruleName;
        this.parameterTypes = parameterTypes;
        this.rpcExt = rpcExt;
        this.enabled = enabled;
        this.host = host;
        this.port = port;
        this.pluginNames = pluginNames;
        this.registerMetaData = registerMetaData;
        this.timeMillis = System.currentTimeMillis();
        this.addPrefixed = addPrefixed;
    }

    public MetaDataRegisterDTO() {
    }

    private MetaDataRegisterDTO(Builder builder) {
        this.appName = builder.appName;
        this.contextPath = builder.contextPath;
        this.path = builder.path;
        this.pathDesc = builder.pathDesc;
        this.rpcType = builder.rpcType;
        this.serviceName = builder.serviceName;
        this.methodName = builder.methodName;
        this.ruleName = builder.ruleName;
        this.parameterTypes = builder.parameterTypes;
        this.rpcExt = builder.rpcExt;
        this.enabled = builder.enabled;
        this.host = builder.host;
        this.port = builder.port;
        this.pluginNames = builder.pluginNames;
        this.registerMetaData = builder.registerMetaData;
        this.timeMillis = System.currentTimeMillis();
        this.addPrefixed = builder.addPrefixed;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public DataType getType() {
        return DataType.META_DATA;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPathDesc() {
        return this.pathDesc;
    }

    public void setPathDesc(String pathDesc) {
        this.pathDesc = pathDesc;
    }

    public String getRpcType() {
        return this.rpcType;
    }

    public void setRpcType(String rpcType) {
        this.rpcType = rpcType;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public String getRuleName() {
        return this.ruleName;
    }

    public void setRuleName(String ruleName) {
        this.ruleName = ruleName;
    }

    public String getParameterTypes() {
        return this.parameterTypes;
    }

    public void setParameterTypes(String parameterTypes) {
        this.parameterTypes = parameterTypes;
    }

    public String getRpcExt() {
        return this.rpcExt;
    }

    public void setRpcExt(String rpcExt) {
        this.rpcExt = rpcExt;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public List<String> getPluginNames() {
        return this.pluginNames;
    }

    public void setPluginNames(List<String> pluginNames) {
        this.pluginNames = pluginNames;
    }

    public boolean isRegisterMetaData() {
        return this.registerMetaData;
    }

    public void setRegisterMetaData(boolean registerMetaData) {
        this.registerMetaData = registerMetaData;
    }

    public long getTimeMillis() {
        return this.timeMillis;
    }

    public void setTimeMillis(long timeMillis) {
        this.timeMillis = timeMillis;
    }

    public boolean getAddPrefixed() {
        return this.addPrefixed;
    }

    public void setAddPrefixed(boolean prefixForwardEnable) {
        this.addPrefixed = prefixForwardEnable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetaDataRegisterDTO that = (MetaDataRegisterDTO)o;
        return Objects.equals(this.appName, that.appName) && Objects.equals(this.contextPath, that.contextPath) && Objects.equals(this.path, that.path) && Objects.equals(this.pathDesc, that.pathDesc) && Objects.equals(this.rpcType, that.rpcType) && Objects.equals(this.serviceName, that.serviceName) && Objects.equals(this.methodName, that.methodName) && Objects.equals(this.ruleName, that.ruleName) && Objects.equals(this.parameterTypes, that.parameterTypes) && Objects.equals(this.rpcExt, that.rpcExt) && Objects.equals(this.enabled, that.enabled) && Objects.equals(this.host, that.host) && Objects.equals(this.port, that.port) && Objects.equals(this.pluginNames, that.pluginNames) && Objects.equals(this.registerMetaData, that.registerMetaData) && Objects.equals(this.addPrefixed, that.addPrefixed);
    }

    public int hashCode() {
        return Objects.hash(this.appName, this.contextPath, this.path, this.pathDesc, this.rpcType, this.serviceName, this.methodName, this.ruleName, this.parameterTypes, this.rpcExt, this.enabled, this.host, this.port, this.pluginNames, this.registerMetaData, this.addPrefixed);
    }

    public String toString() {
        return "MetaDataRegisterDTO{appName='" + this.appName + ", contextPath='" + this.contextPath + ", path='" + this.path + ", pathDesc='" + this.pathDesc + ", rpcType='" + this.rpcType + ", serviceName='" + this.serviceName + ", methodName='" + this.methodName + ", ruleName='" + this.ruleName + ", parameterTypes='" + this.parameterTypes + ", rpcExt='" + this.rpcExt + ", enabled=" + this.enabled + ", host='" + this.host + ", port=" + this.port + ", pluginNames=" + this.pluginNames + ", registerMetaData=" + this.registerMetaData + ", timeMillis=" + this.timeMillis + ", addPrefixed=" + this.addPrefixed + '}';
    }

    public static final class Builder {
        private String appName;
        private String contextPath;
        private String path;
        private String pathDesc;
        private String rpcType;
        private String serviceName;
        private String methodName;
        private String ruleName;
        private String parameterTypes;
        private String rpcExt;
        private boolean enabled;
        private String host;
        private Integer port;
        private List<String> pluginNames = Collections.emptyList();
        private boolean registerMetaData;
        private long timeMillis;
        private boolean addPrefixed;

        private Builder() {
        }

        public Builder appName(String appName) {
            this.appName = appName;
            return this;
        }

        public Builder contextPath(String contextPath) {
            this.contextPath = contextPath;
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder pathDesc(String pathDesc) {
            this.pathDesc = pathDesc;
            return this;
        }

        public Builder rpcType(String rpcType) {
            this.rpcType = rpcType;
            return this;
        }

        public Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public Builder methodName(String methodName) {
            this.methodName = methodName;
            return this;
        }

        public Builder ruleName(String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        public Builder parameterTypes(String parameterTypes) {
            this.parameterTypes = parameterTypes;
            return this;
        }

        public Builder rpcExt(String rpcExt) {
            this.rpcExt = rpcExt;
            return this;
        }

        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder host(String host) {
            this.host = host;
            return this;
        }

        public Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public Builder pluginNames(List<String> pluginNames) {
            this.pluginNames = pluginNames;
            return this;
        }

        public Builder registerMetaData(boolean registerMetaData) {
            this.registerMetaData = registerMetaData;
            return this;
        }

        public Builder timeMillis(long timeMillis) {
            this.timeMillis = timeMillis;
            return this;
        }

        public Builder addPrefixed(boolean addPrefixed) {
            this.addPrefixed = addPrefixed;
            return this;
        }

        public MetaDataRegisterDTO build() {
            return new MetaDataRegisterDTO(this);
        }
    }
}

