/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.register.instance.consul;

import com.ecwid.consul.v1.ConsulClient;
import com.ecwid.consul.v1.QueryParams;
import com.ecwid.consul.v1.Response;
import com.ecwid.consul.v1.agent.model.NewService;
import com.ecwid.consul.v1.health.HealthServicesRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.concurrent.ShenyuThreadFactory;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.register.instance.api.ShenyuInstanceRegisterRepository;
import org.apache.shenyu.register.instance.api.config.RegisterConfig;
import org.apache.shenyu.register.instance.api.entity.InstanceEntity;
import org.apache.shenyu.register.instance.api.watcher.WatcherListener;
import org.apache.shenyu.register.instance.consul.TtlScheduler;
import org.apache.shenyu.spi.Join;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Join
public class ConsulInstanceRegisterRepository
implements ShenyuInstanceRegisterRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsulInstanceRegisterRepository.class);
    private ConsulClient consulClient;
    private NewService newService;
    private final ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(Math.max(Runtime.getRuntime().availableProcessors(), 1), ShenyuThreadFactory.create((String)"consul-config-watch", (boolean)true));
    private final List<ScheduledFuture<?>> watchFutures = new ArrayList();
    private final Map<String, Set<WatcherListener>> listenerMap = new ConcurrentHashMap<String, Set<WatcherListener>>();
    private final Object lock = new Object();
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final Map<String, Long> consulIndexes = new HashMap<String, Long>();
    private String token;
    private String waitTime;
    private String watchDelay;
    private String tags;
    private String checkTtl;
    private TtlScheduler ttlScheduler;

    public void init(RegisterConfig config) {
        Properties props = config.getProps();
        this.checkTtl = props.getProperty("checkTtl", "5");
        this.token = props.getProperty("token", "");
        this.waitTime = props.getProperty("waitTime", "30");
        this.watchDelay = props.getProperty("watchDelay", "5");
        this.tags = props.getProperty("tags");
        String port = props.getProperty("port", "8500");
        this.consulClient = new ConsulClient(config.getServerLists(), Integer.parseInt(port));
        this.ttlScheduler = new TtlScheduler(Integer.parseInt(this.checkTtl), this.consulClient);
        Runtime.getRuntime().addShutdownHook(new Thread(this::close));
    }

    public void persistInstance(InstanceEntity instance) {
        String instanceNodeName = this.buildInstanceNodeName(instance);
        this.newService = new NewService();
        this.newService.setName(instance.getAppName());
        this.newService.setId(String.join((CharSequence)"-", instance.getAppName(), instanceNodeName));
        this.newService.setAddress(instance.getHost());
        this.newService.setPort(instance.getPort());
        this.newService.setCheck(this.createCheck());
        if (StringUtils.isNotEmpty((CharSequence)this.tags)) {
            this.newService.setTags(new ArrayList<String>(Arrays.asList(this.tags.split(","))));
        }
        this.newService.setMeta(Collections.singletonMap("nodeData", GsonUtils.getInstance().toJson((Object)instance)));
        this.consulClient.agentServiceRegister(this.newService, this.token);
        this.ttlScheduler.add(this.newService.getId());
        LOGGER.info("consul client register success: {}", (Object)this.newService);
    }

    private NewService.Check createCheck() {
        NewService.Check check = new NewService.Check();
        check.setTtl(this.checkTtl + "s");
        return check;
    }

    public void close() {
        if (this.running.compareAndSet(true, false) && !ObjectUtils.isEmpty(this.watchFutures)) {
            this.watchFutures.forEach(watchFuture -> watchFuture.cancel(true));
        }
        if (!ObjectUtils.isEmpty((Object)this.newService)) {
            this.consulClient.agentServiceDeregister(this.newService.getId(), this.token);
            this.ttlScheduler.remove(this.newService.getId());
        }
    }

    private String buildInstanceNodeName(InstanceEntity instance) {
        String host = instance.getHost();
        int port = instance.getPort();
        return String.join((CharSequence)":", host, Integer.toString(port));
    }

    public List<InstanceEntity> selectInstancesAndWatcher(String selectKey, WatcherListener watcherListener) {
        this.watcherStart(selectKey, watcherListener);
        return this.getHealthServices(selectKey, "-1");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void watcherStart(String selectKey, WatcherListener watcherListener) {
        this.running.compareAndSet(false, true);
        Set eventListeners = this.listenerMap.get(selectKey);
        if (!ObjectUtils.isEmpty(eventListeners)) {
            eventListeners.add((WatcherListener)watcherListener);
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            eventListeners = this.listenerMap.computeIfAbsent(selectKey, s -> new HashSet());
        }
        eventListeners.add(watcherListener);
        this.watchFutures.add(this.executor.scheduleWithFixedDelay(() -> this.watchConfigKeyValues(selectKey), 5L, Integer.parseInt(this.watchDelay), TimeUnit.SECONDS));
    }

    public void watchConfigKeyValues(String selectKey) {
        if (!this.running.get()) {
            return;
        }
        List<InstanceEntity> healthServices = this.getHealthServices(selectKey, this.waitTime);
        Set<WatcherListener> eventListeners = Optional.ofNullable(this.listenerMap.get(selectKey)).orElse(Collections.emptySet());
        eventListeners.forEach(eventListener -> eventListener.listener(healthServices));
    }

    public List<InstanceEntity> getHealthServices(String selectKey, String waitTime) {
        Long newIndex = Optional.ofNullable(this.consulIndexes.get(selectKey)).orElse(-1L);
        HealthServicesRequest healthServicesRequest = HealthServicesRequest.newBuilder().setToken(this.token).setPassing(true).setQueryParams(QueryParams.Builder.builder().setWaitTime(Long.parseLong(waitTime)).setIndex(newIndex.longValue()).build()).build();
        Response healthServices = this.consulClient.getHealthServices(selectKey, healthServicesRequest);
        this.consulIndexes.put(selectKey, healthServices.getConsulIndex());
        if (CollectionUtils.isEmpty((Collection)((Collection)healthServices.getValue()))) {
            return Collections.emptyList();
        }
        return ((List)healthServices.getValue()).stream().map(healthService -> InstanceEntity.builder().appName(healthService.getService().getService()).host(healthService.getService().getAddress()).port(healthService.getService().getPort()).build()).collect(Collectors.toList());
    }
}

