/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.register.instance.consul;

import com.ecwid.consul.v1.ConsulClient;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TtlScheduler {
    private static final Log log = LogFactory.getLog(TtlScheduler.class);
    private final Map<String, ScheduledFuture<?>> serviceHeartbeats = new ConcurrentHashMap();
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private final int ttl;
    private final ConsulClient client;

    public TtlScheduler(int ttl, ConsulClient client) {
        this.ttl = ttl;
        this.client = client;
    }

    public void add(String instanceId) {
        ScheduledFuture<?> task = this.scheduler.scheduleAtFixedRate(new ConsulHeartbeatTask(instanceId), this.ttl, this.ttl, TimeUnit.SECONDS);
        ScheduledFuture<?> previousTask = this.serviceHeartbeats.put(instanceId, task);
        if (previousTask != null) {
            previousTask.cancel(true);
        }
    }

    public void remove(String instanceId) {
        ScheduledFuture<?> task = this.serviceHeartbeats.get(instanceId);
        if (task != null) {
            task.cancel(true);
        }
        this.serviceHeartbeats.remove(instanceId);
    }

    private class ConsulHeartbeatTask
    implements Runnable {
        private String checkId;

        ConsulHeartbeatTask(String serviceId) {
            this.checkId = serviceId;
            if (!this.checkId.startsWith("service:")) {
                this.checkId = "service:" + this.checkId;
            }
        }

        @Override
        public void run() {
            TtlScheduler.this.client.agentCheckPass(this.checkId);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Sending consul heartbeat for: " + this.checkId));
            }
        }
    }
}

