/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.register.instance.nacos;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.NamingFactory;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.api.naming.pojo.Instance;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.shenyu.common.exception.ShenyuException;
import org.apache.shenyu.register.instance.api.ShenyuInstanceRegisterRepository;
import org.apache.shenyu.register.instance.api.config.RegisterConfig;
import org.apache.shenyu.register.instance.api.entity.InstanceEntity;
import org.apache.shenyu.register.instance.api.watcher.WatcherListener;
import org.apache.shenyu.spi.Join;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Join
public class NacosInstanceRegisterRepository
implements ShenyuInstanceRegisterRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(NacosInstanceRegisterRepository.class);
    private static final String NAMESPACE = "nacosNameSpace";
    private NamingService namingService;
    private String groupName;

    public void init(RegisterConfig config) {
        Properties properties = config.getProps();
        Properties nacosProperties = new Properties();
        this.groupName = properties.getProperty("groupName", "DEFAULT_GROUP");
        String serverAddr = config.getServerLists();
        nacosProperties.put("serverAddr", serverAddr);
        nacosProperties.put("namespace", properties.getProperty(NAMESPACE, ""));
        nacosProperties.put("username", properties.getProperty("username", ""));
        nacosProperties.put("password", properties.getProperty("password", ""));
        nacosProperties.put("accessKey", properties.getProperty("accessKey", ""));
        nacosProperties.put("secretKey", properties.getProperty("secretKey", ""));
        try {
            this.namingService = NamingFactory.createNamingService((Properties)nacosProperties);
        }
        catch (NacosException e) {
            throw new ShenyuException((Throwable)e);
        }
    }

    public void persistInstance(InstanceEntity instance) {
        try {
            Instance inst = new Instance();
            inst.setWeight(1.0);
            inst.setEphemeral(true);
            inst.setIp(instance.getHost());
            inst.setPort(instance.getPort().intValue());
            inst.setInstanceId(this.buildInstanceNodeName(instance));
            inst.setServiceName(instance.getAppName());
            this.namingService.registerInstance(instance.getAppName(), this.groupName, inst);
            LOGGER.info("nacos client register success: {}", (Object)inst);
        }
        catch (NacosException e) {
            throw new ShenyuException((Throwable)e);
        }
    }

    public List<InstanceEntity> selectInstancesAndWatcher(String selectKey, WatcherListener watcherListener) {
        try {
            this.namingService.subscribe(selectKey, event -> watcherListener.listener(this.getInstanceRegisterDTOS(selectKey)));
        }
        catch (Exception e) {
            LOGGER.error("selectInstancesAndWatcher error", (Throwable)e);
        }
        return this.getInstanceRegisterDTOS(selectKey);
    }

    private String buildInstanceNodeName(InstanceEntity instance) {
        String host = instance.getHost();
        int port = instance.getPort();
        return String.join((CharSequence)":", host, Integer.toString(port));
    }

    private List<InstanceEntity> getInstanceRegisterDTOS(String selectKey) {
        ArrayList<InstanceEntity> result = new ArrayList<InstanceEntity>();
        try {
            List instances = this.namingService.selectInstances(selectKey, this.groupName, true);
            instances.forEach(instance -> result.add(this.convertFromInstance((Instance)instance)));
        }
        catch (Exception e) {
            LOGGER.error("getInstanceRegisterDTOS error", (Throwable)e);
        }
        return result;
    }

    private InstanceEntity convertFromInstance(Instance instance) {
        InstanceEntity instanceEntity = new InstanceEntity();
        instanceEntity.setPort(Integer.valueOf(instance.getPort()));
        instanceEntity.setHost(instance.getInstanceId());
        instanceEntity.setAppName(instance.getServiceName());
        return instanceEntity;
    }

    public void close() {
        try {
            this.namingService.shutDown();
        }
        catch (NacosException e) {
            throw new ShenyuException((Throwable)e);
        }
    }
}

