/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.register.instance.zookeeper;

import java.io.Closeable;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.BackgroundPathable;
import org.apache.curator.framework.api.ChildrenDeletable;
import org.apache.curator.framework.api.CuratorWatcher;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.TreeCache;
import org.apache.curator.framework.recipes.cache.TreeCacheListener;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.curator.utils.CloseableUtils;
import org.apache.shenyu.common.exception.ShenyuException;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.register.instance.zookeeper.ZookeeperConfig;
import org.apache.zookeeper.CreateMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZookeeperClient.class);
    private final ZookeeperConfig config;
    private final CuratorFramework client;
    private final Map<String, TreeCache> caches = new ConcurrentHashMap<String, TreeCache>();

    public ZookeeperClient(ZookeeperConfig zookeeperConfig) {
        this.config = zookeeperConfig;
        ExponentialBackoffRetry retryPolicy = new ExponentialBackoffRetry(this.config.getBaseSleepTimeMilliseconds(), this.config.getMaxRetries(), this.config.getMaxSleepTimeMilliseconds());
        CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder().connectString(this.config.getServerLists()).retryPolicy((RetryPolicy)retryPolicy).connectionTimeoutMs(this.config.getConnectionTimeoutMilliseconds()).sessionTimeoutMs(this.config.getSessionTimeoutMilliseconds()).namespace(this.config.getNamespace());
        if (!StringUtils.isEmpty((CharSequence)this.config.getDigest())) {
            builder.authorization("digest", this.config.getDigest().getBytes(StandardCharsets.UTF_8));
        }
        this.client = builder.build();
    }

    public void start() {
        this.client.start();
        try {
            this.client.blockUntilConnected();
        }
        catch (InterruptedException e) {
            LOGGER.warn("Interrupted during zookeeper client starting.");
            Thread.currentThread().interrupt();
        }
    }

    public void close() {
        for (Map.Entry<String, TreeCache> cache : this.caches.entrySet()) {
            CloseableUtils.closeQuietly((Closeable)((Closeable)cache.getValue()));
        }
        CloseableUtils.closeQuietly((Closeable)this.client);
    }

    public CuratorFramework getClient() {
        return this.client;
    }

    public boolean isExist(String key) {
        try {
            return null != this.client.checkExists().forPath(key);
        }
        catch (Exception e) {
            throw new ShenyuException((Throwable)e);
        }
    }

    public String getDirectly(String key) {
        try {
            byte[] ret = (byte[])this.client.getData().forPath(key);
            return Objects.isNull(ret) ? null : new String(ret, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new ShenyuException((Throwable)e);
        }
    }

    public String get(String key) {
        TreeCache cache = this.findFromcache(key);
        if (Objects.isNull(cache)) {
            return this.getDirectly(key);
        }
        ChildData data = cache.getCurrentData(key);
        if (Objects.isNull(data)) {
            return this.getDirectly(key);
        }
        return Objects.isNull(data.getData()) ? null : new String(data.getData(), StandardCharsets.UTF_8);
    }

    public void createOrUpdate(String key, String value, CreateMode mode) {
        String val = StringUtils.isEmpty((CharSequence)value) ? "" : value;
        try {
            ((ACLBackgroundPathAndBytesable)this.client.create().orSetData().creatingParentsIfNeeded().withMode(mode)).forPath(key, val.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            throw new ShenyuException((Throwable)e);
        }
    }

    public void createOrUpdate(String key, Object value, CreateMode mode) {
        if (value != null) {
            String val = GsonUtils.getInstance().toJson(value);
            this.createOrUpdate(key, val, mode);
        } else {
            this.createOrUpdate(key, "", mode);
        }
    }

    public void delete(String key) {
        try {
            ((ChildrenDeletable)this.client.delete().guaranteed()).deletingChildrenIfNeeded().forPath(key);
        }
        catch (Exception e) {
            throw new ShenyuException((Throwable)e);
        }
    }

    public List<String> getChildren(String key) {
        try {
            return (List)this.client.getChildren().forPath(key);
        }
        catch (Exception e) {
            throw new ShenyuException((Throwable)e);
        }
    }

    public TreeCache getCache(String path) {
        return this.caches.get(path);
    }

    public TreeCache addCache(String path, TreeCacheListener ... listeners) {
        TreeCache cache = TreeCache.newBuilder((CuratorFramework)this.client, (String)path).build();
        this.caches.put(path, cache);
        if (listeners != null && listeners.length > 0) {
            for (TreeCacheListener listener : listeners) {
                cache.getListenable().addListener((Object)listener);
            }
        }
        try {
            cache.start();
        }
        catch (Exception e) {
            throw new ShenyuException("failed to add curator cache.", (Throwable)e);
        }
        return cache;
    }

    public List<String> subscribeChildrenChanges(String key, CuratorWatcher curatorWatcher) {
        try {
            return (List)((BackgroundPathable)this.client.getChildren().usingWatcher(curatorWatcher)).forPath(key);
        }
        catch (Exception e) {
            throw new ShenyuException((Throwable)e);
        }
    }

    private TreeCache findFromcache(String key) {
        for (Map.Entry<String, TreeCache> cache : this.caches.entrySet()) {
            if (!key.startsWith(cache.getKey())) continue;
            return cache.getValue();
        }
        return null;
    }
}

