/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.web.filter;

import java.net.URI;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class CollapseSlashesFilter
implements WebFilter {
    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        ServerHttpRequest request = exchange.getRequest();
        String newPath = request.getURI().getRawPath().replaceAll("/{2,}", "/");
        if (!request.getURI().getRawPath().equals(newPath)) {
            URI newUri = request.getURI().resolve(newPath);
            ServerHttpRequest newRequest = request.mutate().uri(newUri).build();
            return chain.filter(exchange.mutate().request(newRequest).build());
        }
        return chain.filter(exchange);
    }
}

