/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.web.loader;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.shenyu.plugin.api.ShenyuPlugin;
import org.apache.shenyu.plugin.api.utils.SpringBeanUtils;
import org.apache.shenyu.plugin.base.handler.PluginDataHandler;
import org.apache.shenyu.web.loader.PluginJarParser;
import org.apache.shenyu.web.loader.ShenyuLoaderResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

public final class ShenyuPluginClassLoader
extends ClassLoader
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(ShenyuPluginClassLoader.class);
    private final ReentrantLock lock = new ReentrantLock();
    private final Map<String, Class<?>> classCache = new ConcurrentHashMap();
    private final Map<String, byte[]> resourceCache = new ConcurrentHashMap<String, byte[]>();
    private final PluginJarParser.PluginJar pluginJar;

    public ShenyuPluginClassLoader(PluginJarParser.PluginJar pluginJar) {
        super(ShenyuPluginClassLoader.class.getClassLoader());
        this.pluginJar = pluginJar;
    }

    private boolean checkExistence(String className) {
        try {
            return Objects.nonNull(this.getParent().loadClass(className));
        }
        catch (ClassNotFoundException cfe) {
            return false;
        }
    }

    public List<ShenyuLoaderResult> loadUploadedJarPlugins() {
        ArrayList<ShenyuLoaderResult> results = new ArrayList<ShenyuLoaderResult>();
        Set<String> names = this.pluginJar.getClazzMap().keySet();
        names.forEach(className -> {
            try {
                Object instance = this.getOrCreateSpringBean((String)className);
                if (Objects.nonNull(instance)) {
                    results.add(this.buildResult(instance));
                    LOG.info("The class successfully loaded into a upload-Jar-plugin {} is registered as a spring bean", className);
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                LOG.warn("Registering upload-Jar-plugins succeeds spring bean fails:{}", className, (Object)e);
            }
        });
        return results;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        byte[] cacheByte = this.resourceCache.get(name);
        if (cacheByte != null) {
            return new ByteArrayInputStream(cacheByte);
        }
        byte[] bytes = this.pluginJar.getResourceMap().get(name);
        if (bytes != null) {
            this.resourceCache.put(name, bytes);
            return new ByteArrayInputStream(bytes);
        }
        return super.getResourceAsStream(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        if (this.ability(name)) {
            return this.getParent().loadClass(name);
        }
        Class<?> clazz = this.classCache.get(name);
        if (clazz != null) {
            return clazz;
        }
        ShenyuPluginClassLoader shenyuPluginClassLoader = this;
        synchronized (shenyuPluginClassLoader) {
            clazz = this.classCache.get(name);
            if (clazz == null && this.pluginJar.getClazzMap().containsKey(name) && !this.checkExistence(name)) {
                byte[] bytes = this.pluginJar.getClazzMap().get(name);
                clazz = this.defineClass(name, bytes, 0, bytes.length);
                this.classCache.put(name, clazz);
                return clazz;
            }
        }
        throw new ClassNotFoundException(String.format("Class name is %s not found.", name));
    }

    @Override
    public void close() {
        Set<String> clazzNames = this.pluginJar.getClazzMap().keySet();
        for (String clazzName : clazzNames) {
            SpringBeanUtils.getInstance().destroyBean(clazzName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T getOrCreateSpringBean(String className) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        if (SpringBeanUtils.getInstance().existBean(className)) {
            return (T)SpringBeanUtils.getInstance().getBeanByClassName(className);
        }
        this.lock.lock();
        try {
            Object inst = SpringBeanUtils.getInstance().getBeanByClassName(className);
            if (Objects.isNull(inst)) {
                boolean next;
                Class<?> clazz = Class.forName(className, false, this);
                boolean bl = next = ShenyuPlugin.class.isAssignableFrom(clazz) || PluginDataHandler.class.isAssignableFrom(clazz);
                if (!next) {
                    Annotation[] annotations = clazz.getAnnotations();
                    next = Arrays.stream(annotations).anyMatch(e -> e.annotationType().equals(Component.class) || e.annotationType().equals(Service.class));
                }
                if (next) {
                    GenericBeanDefinition beanDefinition = new GenericBeanDefinition();
                    beanDefinition.setBeanClassName(className);
                    beanDefinition.setAutowireCandidate(true);
                    beanDefinition.setRole(2);
                    String beanName = SpringBeanUtils.getInstance().registerBean((BeanDefinition)beanDefinition, (ClassLoader)this);
                    inst = SpringBeanUtils.getInstance().getBeanByClassName(beanName);
                }
            }
            Object object = inst;
            return (T)object;
        }
        finally {
            this.lock.unlock();
        }
    }

    private ShenyuLoaderResult buildResult(Object instance) {
        ShenyuLoaderResult result = new ShenyuLoaderResult();
        if (instance instanceof ShenyuPlugin) {
            result.setShenyuPlugin((ShenyuPlugin)instance);
        } else if (instance instanceof PluginDataHandler) {
            result.setPluginDataHandler((PluginDataHandler)instance);
        }
        return result;
    }

    private boolean ability(String name) {
        return !this.pluginJar.getClazzMap().containsKey(name);
    }

    public boolean compareVersion(String version) {
        return this.pluginJar.getVersion().equals(version);
    }

    static {
        ShenyuPluginClassLoader.registerAsParallelCapable();
    }
}

