/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.response;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.solr.common.util.NamedList;

public class TermsResponse {
    private Map<String, List<Term>> termMap = new HashMap<String, List<Term>>();

    public TermsResponse(NamedList<NamedList<Object>> termsInfo) {
        for (int i = 0; i < termsInfo.size(); ++i) {
            String fieldName = termsInfo.getName(i);
            ArrayList<Term> itemList = new ArrayList<Term>();
            NamedList<Object> items = termsInfo.getVal(i);
            for (int j = 0; j < items.size(); ++j) {
                Term t;
                String term = items.getName(j);
                Object val = items.getVal(j);
                if (val instanceof NamedList) {
                    NamedList termStats = (NamedList)val;
                    t = new Term(term, ((Number)termStats.get("df")).longValue(), ((Number)termStats.get("ttf")).longValue());
                } else {
                    t = new Term(term, ((Number)val).longValue());
                }
                itemList.add(t);
            }
            this.termMap.put(fieldName, itemList);
        }
    }

    public List<Term> getTerms(String field) {
        return this.termMap.get(field);
    }

    public Map<String, List<Term>> getTermMap() {
        return this.termMap;
    }

    public static class Term {
        private String term;
        private long frequency;
        private long totalTermFreq;

        public Term(String term, long frequency) {
            this(term, frequency, 0L);
        }

        public Term(String term, long frequency, long totalTermFreq) {
            this.term = term;
            this.frequency = frequency;
            this.totalTermFreq = totalTermFreq;
        }

        public String getTerm() {
            return this.term;
        }

        public void setTerm(String term) {
            this.term = term;
        }

        public long getFrequency() {
            return this.frequency;
        }

        public void setFrequency(long frequency) {
            this.frequency = frequency;
        }

        public void addFrequency(long frequency) {
            this.frequency += frequency;
        }

        public long getTotalTermFreq() {
            return this.totalTermFreq;
        }

        public void setTotalTermFreq(long totalTermFreq) {
            this.totalTermFreq = totalTermFreq;
        }

        public void addTotalTermFreq(long totalTermFreq) {
            this.totalTermFreq += totalTermFreq;
        }
    }
}

