/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.util;

import java.util.Iterator;

public final class IntegerRange
implements Iterable<Integer> {
    private final int start;
    private final int finish;

    public IntegerRange(int start, int finish) {
        this.start = start;
        this.finish = finish;
    }

    public int getFinish() {
        return this.finish;
    }

    public int getStart() {
        return this.start;
    }

    public String toString() {
        return String.format("%d..%d", this.start, this.finish);
    }

    @Override
    public Iterator<Integer> iterator() {
        return new RangeIterator();
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 31 + this.finish;
        result = 31 * result + this.start;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IntegerRange other = (IntegerRange)obj;
        if (this.finish != other.finish) {
            return false;
        }
        return this.start == other.start;
    }

    private class RangeIterator
    implements Iterator<Integer> {
        private final int increment;
        private int value;
        private boolean hasNext;

        RangeIterator() {
            this.value = IntegerRange.this.start;
            this.hasNext = true;
            this.increment = IntegerRange.this.start < IntegerRange.this.finish ? 1 : -1;
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public Integer next() {
            if (!this.hasNext) {
                throw new IllegalStateException();
            }
            int result = this.value;
            this.hasNext = this.value != IntegerRange.this.finish;
            this.value += this.increment;
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

