/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal.services;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Set;
import org.apache.tapestry5.commons.services.PlasticProxyFactory;
import org.apache.tapestry5.commons.util.CollectionFactory;
import org.apache.tapestry5.ioc.AnnotationAccess;
import org.apache.tapestry5.ioc.internal.services.AbtractAspectInterceptorBuilder;
import org.apache.tapestry5.plastic.InstructionBuilder;
import org.apache.tapestry5.plastic.InstructionBuilderCallback;
import org.apache.tapestry5.plastic.MethodAdvice;
import org.apache.tapestry5.plastic.MethodDescription;
import org.apache.tapestry5.plastic.PlasticClass;
import org.apache.tapestry5.plastic.PlasticClassTransformation;
import org.apache.tapestry5.plastic.PlasticField;

public class AspectInterceptorBuilderImpl<T>
extends AbtractAspectInterceptorBuilder<T> {
    private final Class<T> serviceInterface;
    private final Set<Method> allMethods = CollectionFactory.newSet();
    private final PlasticClassTransformation transformation;
    private final PlasticClass plasticClass;

    public AspectInterceptorBuilderImpl(AnnotationAccess annotationAccess, PlasticProxyFactory plasticProxyFactory, Class<T> serviceInterface, T delegate, String description) {
        super(annotationAccess);
        this.serviceInterface = serviceInterface;
        final Class<?> delegateType = delegate.getClass();
        this.transformation = plasticProxyFactory.createProxyTransformation(serviceInterface, delegateType);
        this.plasticClass = this.transformation.getPlasticClass();
        this.plasticClass.addToString(description);
        this.allMethods.addAll(Arrays.asList(serviceInterface.getMethods()));
        final PlasticField delegateField = this.plasticClass.introduceField(serviceInterface, "delegate").inject(delegate);
        for (Method method : this.allMethods) {
            this.plasticClass.introduceMethod(method).delegateTo(delegateField);
        }
        String delegateTypeName = delegateType.getName();
        MethodDescription getDelegateMethodDescription = new MethodDescription(delegateTypeName, "_____internalGetDelegate_DONT_CALL_THIS_METHOD_____", new String[0]);
        this.plasticClass.introduceMethod(getDelegateMethodDescription, new InstructionBuilderCallback(){

            public void doBuild(InstructionBuilder builder) {
                builder.loadThis().getField(delegateField);
                builder.checkcast(delegateType).returnResult();
            }
        });
    }

    @Override
    public void adviseMethod(Method method, MethodAdvice advice) {
        assert (method != null);
        assert (advice != null);
        if (!this.allMethods.contains(method)) {
            throw new IllegalArgumentException(String.format("Method %s is not defined for interface %s.", method, this.serviceInterface));
        }
        this.plasticClass.introduceMethod(method).addAdvice(advice);
    }

    @Override
    public void adviseAllMethods(MethodAdvice advice) {
        for (Method m : this.serviceInterface.getMethods()) {
            this.adviseMethod(m, advice);
        }
    }

    @Override
    public Class getInterface() {
        return this.serviceInterface;
    }

    @Override
    public T build() {
        return (T)this.transformation.createInstantiator().newInstance();
    }
}

