/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.test;

import java.io.File;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.tapestry5.test.ServletContainerRunner;
import org.apache.tapestry5.test.TapestryRunnerConstants;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ssl.SslSocketConnector;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.webapp.WebAppContext;

public class JettyRunner
implements ServletContainerRunner {
    private Server jettyServer;
    private String description;
    private int port;
    private int sslPort;

    public JettyRunner() {
    }

    public JettyRunner(String webappFolder, String contextPath, int port, int sslPort) throws Exception {
        this.configure(webappFolder, contextPath, port, sslPort).start();
    }

    public JettyRunner configure(String webappFolder, String contextPath, int port, int sslPort) throws Exception {
        this.port = port;
        this.sslPort = sslPort;
        String expandedPath = this.expand(webappFolder);
        this.description = String.format("<JettyRunner: %s:%s/%s (%s)", contextPath, port, sslPort, expandedPath);
        this.jettyServer = new Server(port);
        WebAppContext webapp = new WebAppContext();
        webapp.setContextPath(contextPath);
        webapp.setWar(expandedPath);
        File keystoreFile = new File(TapestryRunnerConstants.MODULE_BASE_DIR, "src/test/conf/keystore");
        if (keystoreFile.exists()) {
            SslContextFactory sslContextFactory = new SslContextFactory();
            sslContextFactory.setKeyStorePath(keystoreFile.getAbsolutePath());
            sslContextFactory.setKeyStorePassword("tapestry");
            sslContextFactory.setKeyManagerPassword("tapestry");
            SslSocketConnector sslConnector = new SslSocketConnector(sslContextFactory);
            sslConnector.setPort(sslPort);
            this.jettyServer.addConnector((Connector)sslConnector);
        }
        this.jettyServer.setHandler((Handler)webapp);
        return this;
    }

    public void start() throws Exception {
        this.jettyServer.start();
    }

    @Override
    public void stop() {
        System.out.printf("Stopping Jetty instance on port %d/%d\n", this.port, this.sslPort);
        try {
            this.jettyServer.stop();
        }
        catch (Exception ex) {
            throw new RuntimeException("Error stopping Jetty instance: " + ex.toString(), ex);
        }
        System.out.println("Jetty instance has stopped.");
    }

    public Server getServer() {
        return this.jettyServer;
    }

    public String toString() {
        return this.description;
    }

    protected String expand(String moduleLocalPath) {
        File path = new File(moduleLocalPath);
        if (path.isAbsolute() && path.isDirectory()) {
            return moduleLocalPath;
        }
        return new File(TapestryRunnerConstants.MODULE_BASE_DIR, moduleLocalPath).getPath();
    }

    public static void main(String[] args) throws Exception {
        String commandName = JettyRunner.class.getName();
        Options options = new Options();
        String webapp = "src/main/webapp";
        String context = "/";
        int httpPort = 8080;
        int sslPort = 8443;
        OptionBuilder.withLongOpt((String)"directory");
        OptionBuilder.withDescription((String)"Root context directory (defaults to 'src/main/webapp')");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"DIR");
        Options options2 = options.addOption(OptionBuilder.create((char)'d'));
        OptionBuilder.withLongOpt((String)"context");
        OptionBuilder.withDescription((String)"Context path for application (defaults to '/')");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"CONTEXT");
        Options options3 = options2.addOption(OptionBuilder.create((char)'c'));
        OptionBuilder.withLongOpt((String)"port");
        OptionBuilder.withDescription((String)"HTTP port (defaults to 8080)");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"PORT");
        Options options4 = options3.addOption(OptionBuilder.create((char)'p'));
        OptionBuilder.withLongOpt((String)"secure-port");
        OptionBuilder.withDescription((String)"HTTPS port (defaults to 8443)");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"PORT");
        options4.addOption(OptionBuilder.create((char)'s')).addOption("h", "help", false, "Display command usage");
        CommandLine line = new BasicParser().parse(options, args);
        boolean usage = line.hasOption('h');
        if (!usage) {
            File folder;
            if (line.hasOption('d')) {
                webapp = line.getOptionValue('d');
            }
            if (!(folder = new File(webapp)).exists()) {
                System.err.printf("%s: Directory `%s' does not exist.%n", commandName, webapp);
                System.exit(-1);
            }
            if (line.hasOption('p')) {
                try {
                    httpPort = Integer.parseInt(line.getOptionValue('p'));
                }
                catch (NumberFormatException e) {
                    usage = true;
                }
            }
            if (line.hasOption('s')) {
                try {
                    sslPort = Integer.parseInt(line.getOptionValue('s'));
                }
                catch (NumberFormatException e) {
                    usage = true;
                }
            }
            if (line.hasOption('c')) {
                context = line.getOptionValue('c');
            }
        }
        if (usage) {
            new HelpFormatter().printHelp(commandName, options);
            System.exit(-1);
        }
        new JettyRunner(webapp, context, httpPort, sslPort);
    }
}

