/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.batch.fs;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ArrayBlockingQueue;
import org.apache.commons.io.IOUtils;
import org.apache.tika.batch.FileResource;
import org.apache.tika.batch.OutputStreamFactory;
import org.apache.tika.batch.ParserFactory;
import org.apache.tika.batch.fs.AbstractFSConsumer;
import org.apache.tika.batch.fs.FSProperties;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.ContentHandlerFactory;
import org.xml.sax.ContentHandler;

public class BasicTikaFSConsumer
extends AbstractFSConsumer {
    private boolean parseRecursively = true;
    private final Parser parser;
    private final ContentHandlerFactory contentHandlerFactory;
    private final OutputStreamFactory fsOSFactory;
    private Charset outputEncoding = StandardCharsets.UTF_8;

    @Deprecated
    public BasicTikaFSConsumer(ArrayBlockingQueue<FileResource> queue, ParserFactory parserFactory, ContentHandlerFactory contentHandlerFactory, OutputStreamFactory fsOSFactory, TikaConfig tikaConfig) {
        super(queue);
        this.parser = parserFactory.getParser(tikaConfig);
        this.contentHandlerFactory = contentHandlerFactory;
        this.fsOSFactory = fsOSFactory;
    }

    public BasicTikaFSConsumer(ArrayBlockingQueue<FileResource> queue, Parser parser, ContentHandlerFactory contentHandlerFactory, OutputStreamFactory fsOSFactory) {
        super(queue);
        this.parser = parser;
        this.contentHandlerFactory = contentHandlerFactory;
        this.fsOSFactory = fsOSFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processFileResource(FileResource fileResource) {
        OutputStream os;
        ParseContext context = new ParseContext();
        if (this.parseRecursively) {
            context.set(Parser.class, (Object)this.parser);
        }
        if ((os = this.getOutputStream(this.fsOSFactory, fileResource)) == null) {
            LOG.debug("Skipping: {}", (Object)fileResource.getMetadata().get(FSProperties.FS_REL_PATH));
            return false;
        }
        InputStream is = this.getInputStream(fileResource);
        if (is == null) {
            IOUtils.closeQuietly((OutputStream)os);
            return false;
        }
        ContentHandler handler = this.contentHandlerFactory.getNewContentHandler(os, this.getOutputEncoding());
        Throwable thrown = null;
        try {
            this.parse(fileResource.getResourceId(), this.parser, is, handler, fileResource.getMetadata(), context);
        }
        catch (Error t) {
            throw t;
        }
        catch (Throwable t) {
            thrown = t;
        }
        finally {
            this.flushAndClose(os);
        }
        return thrown == null;
    }

    public Charset getOutputEncoding() {
        return this.outputEncoding;
    }

    public void setOutputEncoding(Charset charset) {
        this.outputEncoding = charset;
    }
}

