/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import org.apache.tomcat.util.net.SocketEvent;
import org.apache.tomcat.util.net.SocketWrapperBase;

public abstract class SocketProcessorBase<S>
implements Runnable {
    protected SocketWrapperBase<S> socketWrapper;
    protected SocketEvent event;

    public SocketProcessorBase(SocketWrapperBase<S> socketWrapper, SocketEvent event) {
        this.reset(socketWrapper, event);
    }

    public void reset(SocketWrapperBase<S> socketWrapper, SocketEvent event) {
        this.socketWrapper = socketWrapper;
        if (event == null) {
            throw new NullPointerException();
        }
        this.event = event;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        SocketWrapperBase<S> socketWrapperBase = this.socketWrapper;
        synchronized (socketWrapperBase) {
            if (this.socketWrapper.isClosed()) {
                return;
            }
            this.doRun();
        }
    }

    protected abstract void doRun();
}

