/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.mfa;

import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.MultifactorAuthenticationProviderBypass;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.web.flow.mfa.AbstractMultifactorAuthenticationAction;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class MultifactorAuthenticationBypassAction
extends AbstractMultifactorAuthenticationAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(MultifactorAuthenticationBypassAction.class);

    protected Event doExecute(RequestContext requestContext) throws Exception {
        Authentication authentication = WebUtils.getAuthentication((RequestContext)requestContext);
        RegisteredService service = WebUtils.getRegisteredService((RequestContext)requestContext);
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext();
        MultifactorAuthenticationProviderBypass bypass = this.provider.getBypassEvaluator();
        if (requestContext.getCurrentTransition().getId().equals("bypass")) {
            LOGGER.debug("Bypass triggered by MFA webflow for MFA for user [{}] for provider [{}]", (Object)authentication.getPrincipal().getId(), (Object)this.provider.getId());
            bypass.updateAuthenticationToRememberBypass(authentication, this.provider);
            LOGGER.debug("Authentication updated to remember bypass for user [{}] for provider [{}]", (Object)authentication.getPrincipal().getId(), (Object)this.provider.getId());
            return this.yes();
        }
        if (bypass.shouldMultifactorAuthenticationProviderExecute(authentication, service, this.provider, request)) {
            LOGGER.debug("Bypass rules determined MFA should execute for user [{}] for provider [{}]", (Object)authentication.getPrincipal().getId(), (Object)this.provider.getId());
            bypass.updateAuthenticationToForgetBypass(authentication);
            LOGGER.debug("Authentication updated to forget any existing bypass for user [{}] for provider [{}]", (Object)authentication.getPrincipal().getId(), (Object)this.provider.getId());
            return this.no();
        }
        LOGGER.debug("Bypass rules determined MFA should NOT execute for user [{}] for provider [{}]", (Object)authentication.getPrincipal().getId(), (Object)this.provider.getId());
        bypass.updateAuthenticationToRememberBypass(authentication, this.provider);
        LOGGER.debug("Authentication updated to remember bypass for user [{}] for provider [{}]", (Object)authentication.getPrincipal().getId(), (Object)this.provider.getId());
        return this.yes();
    }
}

