/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.mfa;

import lombok.Generated;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceMultifactorPolicy;
import org.apereo.cas.web.flow.mfa.AbstractMultifactorAuthenticationAction;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.action.EventFactorySupport;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class MultifactorAuthenticationFailureAction
extends AbstractMultifactorAuthenticationAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(MultifactorAuthenticationFailureAction.class);
    private final CasConfigurationProperties casProperties;

    protected Event doExecute(RequestContext requestContext) throws Exception {
        RegisteredServiceMultifactorPolicy policy;
        RegisteredService service = WebUtils.getRegisteredService((RequestContext)requestContext);
        RegisteredServiceMultifactorPolicy.FailureModes failureMode = RegisteredServiceMultifactorPolicy.FailureModes.valueOf((String)this.casProperties.getAuthn().getMfa().getGlobalFailureMode());
        LOGGER.debug("Setting failure mode to [{}] based on Global Policy", (Object)failureMode);
        if (this.provider.failureMode() != RegisteredServiceMultifactorPolicy.FailureModes.NOT_SET) {
            LOGGER.debug("Provider failure mode [{}] overriding Global mode [{}]", (Object)this.provider.failureMode(), (Object)failureMode);
            failureMode = this.provider.failureMode();
        }
        if (service != null && (policy = service.getMultifactorPolicy()) != null && policy.getFailureMode() != RegisteredServiceMultifactorPolicy.FailureModes.NOT_SET) {
            LOGGER.debug("Service failure mode [{}] overriding current failure mode [{}]", (Object)policy.getFailureMode(), (Object)failureMode);
            failureMode = policy.getFailureMode();
        }
        LOGGER.debug("Final failure mode has been determined to be [{}]", (Object)failureMode);
        if (failureMode == RegisteredServiceMultifactorPolicy.FailureModes.OPEN) {
            return new EventFactorySupport().event((Object)this, "bypass");
        }
        return new EventFactorySupport().event((Object)this, "unavailable");
    }

    @Generated
    public MultifactorAuthenticationFailureAction(CasConfigurationProperties casProperties) {
        this.casProperties = casProperties;
    }
}

