/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.jdbc;

import java.security.GeneralSecurityException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.security.auth.login.AccountNotFoundException;
import javax.security.auth.login.FailedLoginException;
import javax.sql.DataSource;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.adaptors.jdbc.AbstractJdbcUsernamePasswordAuthenticationHandler;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.HandlerResult;
import org.apereo.cas.authentication.PreventedException;
import org.apereo.cas.authentication.UsernamePasswordCredential;
import org.apereo.cas.authentication.exceptions.AccountDisabledException;
import org.apereo.cas.authentication.exceptions.AccountPasswordMustChangeException;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.IncorrectResultSizeDataAccessException;

public class QueryDatabaseAuthenticationHandler
extends AbstractJdbcUsernamePasswordAuthenticationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryDatabaseAuthenticationHandler.class);
    private final String sql;
    private final String fieldPassword;
    private final String fieldExpired;
    private final String fieldDisabled;
    private final Map<String, Collection<String>> principalAttributeMap;

    public QueryDatabaseAuthenticationHandler(String name, ServicesManager servicesManager, PrincipalFactory principalFactory, Integer order, DataSource dataSource, String sql, String fieldPassword, String fieldExpired, String fieldDisabled, Map<String, Collection<String>> attributes) {
        super(name, servicesManager, principalFactory, order, dataSource);
        this.sql = sql;
        this.fieldPassword = fieldPassword;
        this.fieldExpired = fieldExpired;
        this.fieldDisabled = fieldDisabled;
        this.principalAttributeMap = attributes;
    }

    protected HandlerResult authenticateUsernamePasswordInternal(UsernamePasswordCredential credential, String originalPassword) throws GeneralSecurityException, PreventedException {
        if (StringUtils.isBlank((CharSequence)this.sql) || this.getJdbcTemplate() == null) {
            throw new GeneralSecurityException("Authentication handler is not configured correctly. No SQL statement or JDBC template is found.");
        }
        LinkedHashMap attributes = new LinkedHashMap(this.principalAttributeMap.size());
        String username = credential.getUsername();
        String password = credential.getPassword();
        try {
            Object dbExpired;
            Object dbDisabled;
            Map dbFields = this.getJdbcTemplate().queryForMap(this.sql, new Object[]{username});
            String dbPassword = (String)dbFields.get(this.fieldPassword);
            if (StringUtils.isNotBlank((CharSequence)originalPassword) && !this.matches(originalPassword, dbPassword) || StringUtils.isBlank((CharSequence)originalPassword) && !StringUtils.equals((CharSequence)password, (CharSequence)dbPassword)) {
                throw new FailedLoginException("Password does not match value on record.");
            }
            if (StringUtils.isNotBlank((CharSequence)this.fieldDisabled) && (dbDisabled = dbFields.get(this.fieldDisabled)) != null && (Boolean.TRUE.equals(BooleanUtils.toBoolean((String)dbDisabled.toString())) || dbDisabled.equals(1))) {
                throw new AccountDisabledException("Account has been disabled");
            }
            if (StringUtils.isNotBlank((CharSequence)this.fieldExpired) && (dbExpired = dbFields.get(this.fieldExpired)) != null && (Boolean.TRUE.equals(BooleanUtils.toBoolean((String)dbExpired.toString())) || dbExpired.equals(1))) {
                throw new AccountPasswordMustChangeException("Password has expired");
            }
            this.principalAttributeMap.forEach((key, attributeNames) -> {
                Object attribute = dbFields.get(key);
                if (attribute != null) {
                    LOGGER.debug("Found attribute [{}] from the query results", key);
                    attributeNames.forEach(s -> {
                        LOGGER.debug("Principal attribute [{}] is virtually remapped/renamed to [{}]", key, s);
                        attributes.put(s, CollectionUtils.wrap((Object)attribute.toString()));
                    });
                } else {
                    LOGGER.warn("Requested attribute [{}] could not be found in the query results", key);
                }
            });
        }
        catch (IncorrectResultSizeDataAccessException e) {
            if (e.getActualSize() == 0) {
                throw new AccountNotFoundException(username + " not found with SQL query");
            }
            throw new FailedLoginException("Multiple records found for " + username);
        }
        catch (DataAccessException e) {
            throw new PreventedException("SQL exception while executing query for " + username, (Throwable)e);
        }
        return this.createHandlerResult((Credential)credential, this.principalFactory.createPrincipal(username, attributes), null);
    }
}

