/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.jdbc;

import javax.sql.DataSource;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.adaptors.jdbc.AbstractJdbcUsernamePasswordAuthenticationHandler;
import org.apereo.cas.adaptors.jdbc.BindModeSearchDatabaseAuthenticationHandler;
import org.apereo.cas.adaptors.jdbc.QueryAndEncodeDatabaseAuthenticationHandler;
import org.apereo.cas.adaptors.jdbc.QueryAndEncodeDatabasePasswordEncoder;
import org.apereo.cas.adaptors.jdbc.QueryDatabaseAuthenticationHandler;
import org.apereo.cas.adaptors.jdbc.SearchModeSearchDatabaseAuthenticationHandler;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.CoreAuthenticationUtils;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalNameTransformerUtils;
import org.apereo.cas.authentication.support.password.PasswordEncoderUtils;
import org.apereo.cas.authentication.support.password.PasswordPolicyContext;
import org.apereo.cas.configuration.model.core.authentication.PasswordEncoderProperties;
import org.apereo.cas.configuration.model.core.authentication.PrincipalTransformationProperties;
import org.apereo.cas.configuration.model.support.jdbc.authn.BaseJdbcAuthenticationProperties;
import org.apereo.cas.configuration.model.support.jdbc.authn.BindJdbcAuthenticationProperties;
import org.apereo.cas.configuration.model.support.jdbc.authn.QueryEncodeJdbcAuthenticationProperties;
import org.apereo.cas.configuration.model.support.jdbc.authn.QueryJdbcAuthenticationProperties;
import org.apereo.cas.configuration.model.support.jdbc.authn.SearchJdbcAuthenticationProperties;
import org.apereo.cas.configuration.model.support.jpa.AbstractJpaProperties;
import org.apereo.cas.configuration.support.JpaBeans;
import org.apereo.cas.services.ServicesManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

public final class JdbcAuthenticationUtils {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(JdbcAuthenticationUtils.class);

    public static void configureJdbcAuthenticationHandler(AbstractJdbcUsernamePasswordAuthenticationHandler handler, PasswordPolicyContext config, BaseJdbcAuthenticationProperties properties, ConfigurableApplicationContext applicationContext) {
        handler.setPasswordEncoder(PasswordEncoderUtils.newPasswordEncoder((PasswordEncoderProperties)properties.getPasswordEncoder(), (ApplicationContext)applicationContext));
        handler.setPrincipalNameTransformer(PrincipalNameTransformerUtils.newPrincipalNameTransformer((PrincipalTransformationProperties)properties.getPrincipalTransformation()));
        handler.setPasswordPolicyConfiguration(config);
        handler.setState(properties.getState());
        if (StringUtils.isNotBlank((CharSequence)properties.getCredentialCriteria())) {
            handler.setCredentialSelectionPredicate(CoreAuthenticationUtils.newCredentialSelectionPredicate((String)properties.getCredentialCriteria()));
        }
        LOGGER.trace("Configured authentication handler [{}] to handle database url at [{}]", (Object)handler.getName(), (Object)properties.getName());
    }

    public static AuthenticationHandler newAuthenticationHandler(BindJdbcAuthenticationProperties properties, ConfigurableApplicationContext applicationContext, PrincipalFactory jdbcPrincipalFactory, ServicesManager servicesManager, PasswordPolicyContext passwordPolicy) {
        BindModeSearchDatabaseAuthenticationHandler handler = new BindModeSearchDatabaseAuthenticationHandler(properties, servicesManager, jdbcPrincipalFactory, (DataSource)JpaBeans.newDataSource((AbstractJpaProperties)properties));
        JdbcAuthenticationUtils.configureJdbcAuthenticationHandler(handler, passwordPolicy, (BaseJdbcAuthenticationProperties)properties, applicationContext);
        return handler;
    }

    public static AuthenticationHandler newAuthenticationHandler(QueryEncodeJdbcAuthenticationProperties properties, ConfigurableApplicationContext applicationContext, PrincipalFactory jdbcPrincipalFactory, ServicesManager servicesManager, PasswordPolicyContext queryAndEncodePasswordPolicyConfiguration) {
        return JdbcAuthenticationUtils.newAuthenticationHandler(properties, applicationContext, jdbcPrincipalFactory, servicesManager, queryAndEncodePasswordPolicyConfiguration, (DataSource)JpaBeans.newDataSource((AbstractJpaProperties)properties));
    }

    public static AuthenticationHandler newAuthenticationHandler(QueryEncodeJdbcAuthenticationProperties properties, ConfigurableApplicationContext applicationContext, PrincipalFactory jdbcPrincipalFactory, ServicesManager servicesManager, PasswordPolicyContext queryAndEncodePasswordPolicyConfiguration, DataSource dataSource) {
        QueryAndEncodeDatabasePasswordEncoder databasePasswordEncoder = new QueryAndEncodeDatabasePasswordEncoder(properties);
        QueryAndEncodeDatabaseAuthenticationHandler handler = new QueryAndEncodeDatabaseAuthenticationHandler(properties, servicesManager, jdbcPrincipalFactory, dataSource, databasePasswordEncoder);
        JdbcAuthenticationUtils.configureJdbcAuthenticationHandler(handler, queryAndEncodePasswordPolicyConfiguration, (BaseJdbcAuthenticationProperties)properties, applicationContext);
        return handler;
    }

    public static AuthenticationHandler newAuthenticationHandler(QueryJdbcAuthenticationProperties properties, ConfigurableApplicationContext applicationContext, PrincipalFactory jdbcPrincipalFactory, ServicesManager servicesManager, PasswordPolicyContext queryPasswordPolicyConfiguration) {
        QueryDatabaseAuthenticationHandler handler = new QueryDatabaseAuthenticationHandler(properties, servicesManager, jdbcPrincipalFactory, (DataSource)JpaBeans.newDataSource((AbstractJpaProperties)properties));
        JdbcAuthenticationUtils.configureJdbcAuthenticationHandler(handler, queryPasswordPolicyConfiguration, (BaseJdbcAuthenticationProperties)properties, applicationContext);
        return handler;
    }

    public static AuthenticationHandler newAuthenticationHandler(SearchJdbcAuthenticationProperties properties, ConfigurableApplicationContext applicationContext, PrincipalFactory jdbcPrincipalFactory, ServicesManager servicesManager, PasswordPolicyContext searchModePasswordPolicyConfiguration) {
        SearchModeSearchDatabaseAuthenticationHandler handler = new SearchModeSearchDatabaseAuthenticationHandler(properties, servicesManager, jdbcPrincipalFactory, (DataSource)JpaBeans.newDataSource((AbstractJpaProperties)properties));
        JdbcAuthenticationUtils.configureJdbcAuthenticationHandler(handler, searchModePasswordPolicyConfiguration, (BaseJdbcAuthenticationProperties)properties, applicationContext);
        return handler;
    }

    @Generated
    private JdbcAuthenticationUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

