/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.jdbc;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.security.auth.login.AccountNotFoundException;
import javax.security.auth.login.FailedLoginException;
import javax.sql.DataSource;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.adaptors.jdbc.AbstractJdbcUsernamePasswordAuthenticationHandler;
import org.apereo.cas.adaptors.jdbc.DatabasePasswordEncoder;
import org.apereo.cas.authentication.AuthenticationHandlerExecutionResult;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.PreventedException;
import org.apereo.cas.authentication.credential.UsernamePasswordCredential;
import org.apereo.cas.authentication.exceptions.AccountDisabledException;
import org.apereo.cas.authentication.exceptions.AccountPasswordMustChangeException;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.configuration.model.support.jdbc.authn.QueryEncodeJdbcAuthenticationProperties;
import org.apereo.cas.monitor.Monitorable;
import org.apereo.cas.services.ServicesManager;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.IncorrectResultSizeDataAccessException;

@Monitorable
public class QueryAndEncodeDatabaseAuthenticationHandler
extends AbstractJdbcUsernamePasswordAuthenticationHandler<QueryEncodeJdbcAuthenticationProperties> {
    private final DatabasePasswordEncoder databasePasswordEncoder;

    public QueryAndEncodeDatabaseAuthenticationHandler(QueryEncodeJdbcAuthenticationProperties properties, ServicesManager servicesManager, PrincipalFactory principalFactory, DataSource dataSource, DatabasePasswordEncoder databasePasswordEncoder) {
        super(properties, servicesManager, principalFactory, dataSource);
        this.databasePasswordEncoder = databasePasswordEncoder;
    }

    protected AuthenticationHandlerExecutionResult authenticateUsernamePasswordInternal(UsernamePasswordCredential transformedCredential, String originalPassword) throws Throwable {
        String username = transformedCredential.getUsername();
        try {
            String dbDisabled;
            String dbExpired;
            Map<String, Object> sqlQueryResults = this.performSqlQuery(username);
            String digestedPassword = this.databasePasswordEncoder.encode(transformedCredential.toPassword(), sqlQueryResults);
            if (!sqlQueryResults.get(((QueryEncodeJdbcAuthenticationProperties)this.properties).getPasswordFieldName()).equals(digestedPassword)) {
                throw new FailedLoginException("Password does not match value on record.");
            }
            if (StringUtils.isNotBlank((CharSequence)((QueryEncodeJdbcAuthenticationProperties)this.properties).getExpiredFieldName()) && sqlQueryResults.containsKey(((QueryEncodeJdbcAuthenticationProperties)this.properties).getExpiredFieldName()) && (BooleanUtils.toBoolean((String)(dbExpired = sqlQueryResults.get(((QueryEncodeJdbcAuthenticationProperties)this.properties).getExpiredFieldName()).toString())) || "1".equals(dbExpired))) {
                throw new AccountPasswordMustChangeException("Password has expired");
            }
            if (StringUtils.isNotBlank((CharSequence)((QueryEncodeJdbcAuthenticationProperties)this.properties).getDisabledFieldName()) && sqlQueryResults.containsKey(((QueryEncodeJdbcAuthenticationProperties)this.properties).getDisabledFieldName()) && (BooleanUtils.toBoolean((String)(dbDisabled = sqlQueryResults.get(((QueryEncodeJdbcAuthenticationProperties)this.properties).getDisabledFieldName()).toString())) || "1".equals(dbDisabled))) {
                throw new AccountDisabledException("Account has been disabled");
            }
            Map<String, List<Object>> attributes = this.collectPrincipalAttributes(sqlQueryResults);
            Principal principal = this.principalFactory.createPrincipal(username, attributes);
            return this.createHandlerResult((Credential)transformedCredential, principal, new ArrayList(0));
        }
        catch (IncorrectResultSizeDataAccessException e) {
            if (e.getActualSize() == 0) {
                throw new AccountNotFoundException(username + " not found with SQL query");
            }
            throw new FailedLoginException("Multiple records found for " + username);
        }
        catch (DataAccessException e) {
            throw new PreventedException((Throwable)e);
        }
    }

    protected Map<String, Object> performSqlQuery(String username) {
        return this.getJdbcTemplate().queryForMap(((QueryEncodeJdbcAuthenticationProperties)this.properties).getSql(), new Object[]{username});
    }
}

