/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.jdbc;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.apereo.cas.adaptors.jdbc.DatabasePasswordEncoder;
import org.apereo.cas.configuration.model.support.jdbc.authn.QueryEncodeJdbcAuthenticationProperties;
import org.apereo.cas.util.DigestUtils;
import org.apereo.cas.util.function.FunctionUtils;

public class QueryAndEncodeDatabasePasswordEncoder
implements DatabasePasswordEncoder {
    protected final QueryEncodeJdbcAuthenticationProperties properties;

    @Override
    public String encode(String password, Map<String, Object> queryValues) {
        int iterations = this.getIterations(queryValues);
        byte[] dynaSalt = this.getDynamicSalt(queryValues);
        byte[] staticSalt = this.getStaticSalt(queryValues);
        return DigestUtils.rawDigest((String)this.properties.getAlgorithmName(), (byte[])staticSalt, (byte[])dynaSalt, (String)password, (long)iterations);
    }

    protected int getIterations(Map<String, Object> queryValues) {
        int iterations = this.properties.getNumberOfIterations();
        if (queryValues.containsKey(this.properties.getNumberOfIterationsFieldName())) {
            String longAsStr = queryValues.get(this.properties.getNumberOfIterationsFieldName()).toString();
            iterations = Integer.parseInt(longAsStr);
        }
        return iterations;
    }

    protected byte[] getStaticSalt(Map<String, Object> queryValues) {
        return (byte[])FunctionUtils.doIfNotBlank((CharSequence)this.properties.getStaticSalt(), () -> this.properties.getStaticSalt().getBytes(StandardCharsets.UTF_8), () -> ArrayUtils.EMPTY_BYTE_ARRAY);
    }

    protected byte[] getDynamicSalt(Map<String, Object> queryValues) {
        return queryValues.containsKey(this.properties.getSaltFieldName()) ? queryValues.get(this.properties.getSaltFieldName()).toString().getBytes(StandardCharsets.UTF_8) : ArrayUtils.EMPTY_BYTE_ARRAY;
    }

    @Generated
    public QueryAndEncodeDatabasePasswordEncoder(QueryEncodeJdbcAuthenticationProperties properties) {
        this.properties = properties;
    }
}

