/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.jdbc;

import java.util.ArrayList;
import javax.security.auth.login.FailedLoginException;
import javax.sql.DataSource;
import lombok.Generated;
import org.apereo.cas.adaptors.jdbc.AbstractJdbcUsernamePasswordAuthenticationHandler;
import org.apereo.cas.authentication.AuthenticationHandlerExecutionResult;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.credential.UsernamePasswordCredential;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.configuration.model.support.jdbc.authn.SearchJdbcAuthenticationProperties;
import org.apereo.cas.monitor.Monitorable;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.LoggingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Monitorable
public class SearchModeSearchDatabaseAuthenticationHandler
extends AbstractJdbcUsernamePasswordAuthenticationHandler<SearchJdbcAuthenticationProperties> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SearchModeSearchDatabaseAuthenticationHandler.class);

    public SearchModeSearchDatabaseAuthenticationHandler(SearchJdbcAuthenticationProperties properties, ServicesManager servicesManager, PrincipalFactory principalFactory, DataSource datasource) {
        super(properties, servicesManager, principalFactory, datasource);
    }

    protected AuthenticationHandlerExecutionResult authenticateUsernamePasswordInternal(UsernamePasswordCredential credential, String originalPassword) throws Throwable {
        String sql = "SELECT COUNT('x') FROM ".concat(((SearchJdbcAuthenticationProperties)this.properties).getTableUsers()).concat(" WHERE ").concat(((SearchJdbcAuthenticationProperties)this.properties).getFieldUser()).concat(" = ? AND ").concat(((SearchJdbcAuthenticationProperties)this.properties).getFieldPassword()).concat("= ?");
        String username = credential.getUsername();
        try {
            LOGGER.debug("Executing SQL query [{}]", (Object)sql);
            Integer count = (Integer)this.getJdbcTemplate().queryForObject(sql, Integer.class, new Object[]{username, credential.toPassword()});
            if (count == null || count == 0) {
                throw new FailedLoginException(username + " not found with SQL query.");
            }
            Principal principal = this.principalFactory.createPrincipal(username);
            return this.createHandlerResult((Credential)credential, principal, new ArrayList(0));
        }
        catch (Throwable e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            throw new FailedLoginException(e.getMessage());
        }
    }
}

