/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.jpa.AbstractJpaProperties;
import org.apereo.cas.configuration.model.support.jpa.DatabaseProperties;
import org.apereo.cas.configuration.model.support.jpa.JpaConfigDataHolder;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.services.JpaServiceRegistryDaoImpl;
import org.apereo.cas.services.ServiceRegistryDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.vendor.HibernateJpaVendorAdapter;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration(value="jpaServiceRegistryConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@EnableTransactionManagement(proxyTargetClass=true)
public class JpaServiceRegistryConfiguration {
    @Autowired
    private CasConfigurationProperties casProperties;

    @RefreshScope
    @Bean
    public HibernateJpaVendorAdapter jpaServiceVendorAdapter() {
        return Beans.newHibernateJpaVendorAdapter((DatabaseProperties)this.casProperties.getJdbc());
    }

    @Bean
    public String[] jpaServicePackagesToScan() {
        return new String[]{"org.apereo.cas.services", "org.apereo.cas.support.oauth.services", "org.apereo.cas.support.saml.services"};
    }

    @Lazy
    @Bean
    public LocalContainerEntityManagerFactoryBean serviceEntityManagerFactory() {
        return Beans.newEntityManagerFactoryBean((JpaConfigDataHolder)new JpaConfigDataHolder((JpaVendorAdapter)this.jpaServiceVendorAdapter(), "jpaServiceRegistryContext", this.jpaServicePackagesToScan(), this.dataSourceService()), (AbstractJpaProperties)this.casProperties.getServiceRegistry().getJpa());
    }

    @Autowired
    @Bean
    public PlatformTransactionManager transactionManagerServiceReg(@Qualifier(value="serviceEntityManagerFactory") EntityManagerFactory emf) {
        JpaTransactionManager mgmr = new JpaTransactionManager();
        mgmr.setEntityManagerFactory(emf);
        return mgmr;
    }

    @RefreshScope
    @Bean
    public DataSource dataSourceService() {
        return Beans.newHickariDataSource((AbstractJpaProperties)this.casProperties.getServiceRegistry().getJpa());
    }

    @Bean(name={"jpaServiceRegistryDao", "serviceRegistryDao"})
    public ServiceRegistryDao jpaServiceRegistryDao() {
        return new JpaServiceRegistryDaoImpl();
    }
}

