/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.validator;

import java.util.Optional;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIBuilder;
import org.apereo.cas.authentication.AuthenticationServiceSelectionStrategy;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth20AuthenticationServiceSelectionStrategy
implements AuthenticationServiceSelectionStrategy {
    private static final long serialVersionUID = 8517547235465666978L;
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20AuthenticationServiceSelectionStrategy.class);
    private final ServicesManager servicesManager;
    private final ServiceFactory<WebApplicationService> webApplicationServiceFactory;
    private final String callbackUrl;
    private int order = Integer.MIN_VALUE;

    public OAuth20AuthenticationServiceSelectionStrategy(ServicesManager servicesManager, ServiceFactory<WebApplicationService> webApplicationServiceFactory, String callbackUrl) {
        this.servicesManager = servicesManager;
        this.webApplicationServiceFactory = webApplicationServiceFactory;
        this.callbackUrl = callbackUrl;
    }

    public Service resolveServiceFrom(Service service) {
        Optional<NameValuePair> clientId = OAuth20AuthenticationServiceSelectionStrategy.resolveClientIdFromService(service);
        Optional<NameValuePair> redirectUri = OAuth20AuthenticationServiceSelectionStrategy.resolveRedirectUri(service);
        if (clientId.isPresent() && redirectUri.isPresent()) {
            return this.webApplicationServiceFactory.createService(redirectUri.get().getValue());
        }
        return service;
    }

    private static Optional<NameValuePair> resolveClientIdFromService(Service service) {
        try {
            URIBuilder builder = new URIBuilder(service.getId());
            return builder.getQueryParams().stream().filter(p -> p.getName().equals("client_id")).findFirst();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            return Optional.empty();
        }
    }

    private static Optional<NameValuePair> resolveRedirectUri(Service service) {
        try {
            URIBuilder builder = new URIBuilder(service.getId());
            return builder.getQueryParams().stream().filter(p -> p.getName().equals("redirect_uri")).findFirst();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            return Optional.empty();
        }
    }

    public boolean supports(Service service) {
        RegisteredService svc = this.servicesManager.findServiceBy(service);
        boolean res = svc != null && service.getId().startsWith(this.callbackUrl);
        LOGGER.debug("Authentication request is{}identified as an OAuth request", (Object)BooleanUtils.toString((boolean)res, (String)"", (String)" not "));
        return res;
    }

    public int getOrder() {
        return this.order;
    }
}

