/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.response.accesstoken.ext;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.ticket.OAuthToken;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessTokenRequestDataHolder {
    private static final Logger LOGGER = LoggerFactory.getLogger(AccessTokenRequestDataHolder.class);
    private final Service service;
    private final Authentication authentication;
    private final OAuthToken token;
    private final boolean generateRefreshToken;
    private final OAuthRegisteredService registeredService;
    private final TicketGrantingTicket ticketGrantingTicket;

    public AccessTokenRequestDataHolder(OAuthToken token, boolean generateRefreshToken, OAuthRegisteredService registeredService) {
        this(token.getService(), token.getAuthentication(), token, generateRefreshToken, registeredService);
    }

    public AccessTokenRequestDataHolder(Service service, Authentication authentication, OAuthToken token, boolean generateRefreshToken, OAuthRegisteredService registeredService) {
        this.service = service;
        this.authentication = authentication;
        this.token = token;
        this.generateRefreshToken = generateRefreshToken;
        this.registeredService = registeredService;
        this.ticketGrantingTicket = token != null ? token.getGrantingTicket() : null;
    }

    public AccessTokenRequestDataHolder(Service service, Authentication authentication, OAuthRegisteredService registeredService, TicketGrantingTicket ticketGrantingTicket) {
        this.service = service;
        this.authentication = authentication;
        this.registeredService = registeredService;
        this.ticketGrantingTicket = ticketGrantingTicket;
        this.token = null;
        this.generateRefreshToken = false;
    }

    public Service getService() {
        return this.service;
    }

    public Authentication getAuthentication() {
        return this.authentication;
    }

    public OAuthToken getToken() {
        return this.token;
    }

    public boolean isGenerateRefreshToken() {
        return this.generateRefreshToken;
    }

    public OAuthRegisteredService getRegisteredService() {
        return this.registeredService;
    }

    public TicketGrantingTicket getTicketGrantingTicket() {
        return this.ticketGrantingTicket;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("service", (Object)this.service).append("authentication", (Object)this.authentication).append("token", (Object)this.token).append("generateRefreshToken", this.generateRefreshToken).append("registeredService", (Object)this.registeredService).append("ticketGrantingTicket", (Object)this.ticketGrantingTicket).toString();
    }
}

