/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.validator;

import javax.servlet.http.HttpServletRequest;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.validator.OAuth20RequestValidator;
import org.apereo.cas.support.oauth.validator.OAuth20Validator;
import org.pac4j.core.context.J2EContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth20ClientCredentialsGrantTypeRequestValidator
implements OAuth20RequestValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20ClientCredentialsGrantTypeRequestValidator.class);
    private final ServicesManager servicesManager;
    private final OAuth20Validator validator;

    public OAuth20ClientCredentialsGrantTypeRequestValidator(ServicesManager servicesManager, OAuth20Validator validator) {
        this.servicesManager = servicesManager;
        this.validator = validator;
    }

    @Override
    public boolean validate(J2EContext context) {
        HttpServletRequest request = context.getRequest();
        if (!this.validator.checkParameterExist(request, "grant_type")) {
            LOGGER.warn("Grant type must be specified");
            return false;
        }
        String grantType = context.getRequestParameter("grant_type");
        if (!this.validator.checkParameterExist(request, "client_id")) {
            LOGGER.warn("Client id not specified for grant type [{}]", (Object)grantType);
            return false;
        }
        if (!this.validator.checkParameterExist(request, "secret")) {
            LOGGER.warn("Client secret is not specified for grant type [{}]", (Object)grantType);
            return false;
        }
        String clientId = context.getRequestParameter("client_id");
        OAuthRegisteredService registeredService = this.getRegisteredServiceByClientId(clientId);
        if (!this.validator.checkServiceValid((RegisteredService)registeredService)) {
            LOGGER.warn("Registered service [{}] is not found or is not authorized for access.", (Object)registeredService);
            return false;
        }
        return OAuth20Utils.isAuthorizedGrantTypeForService(context, registeredService);
    }

    protected OAuthRegisteredService getRegisteredServiceByClientId(String clientId) {
        return OAuth20Utils.getRegisteredOAuthService(this.servicesManager, clientId);
    }

    @Override
    public boolean supports(J2EContext context) {
        String grantType = context.getRequestParameter("grant_type");
        return OAuth20Utils.isGrantType(grantType, OAuth20GrantTypes.CLIENT_CREDENTIALS);
    }
}

