/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.endpoints;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.profile.OAuth20ProfileScopeToAttributesFilter;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.validator.OAuth20Validator;
import org.apereo.cas.support.oauth.web.endpoints.BaseOAuth20Controller;
import org.apereo.cas.support.oauth.web.views.OAuth20UserProfileViewRenderer;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.TicketState;
import org.apereo.cas.ticket.accesstoken.AccessToken;
import org.apereo.cas.ticket.accesstoken.AccessTokenFactory;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.web.support.CookieRetrievingCookieGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;

public class OAuth20UserProfileControllerController
extends BaseOAuth20Controller {
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20UserProfileControllerController.class);
    protected final OAuth20UserProfileViewRenderer userProfileViewRenderer;

    public OAuth20UserProfileControllerController(ServicesManager servicesManager, TicketRegistry ticketRegistry, OAuth20Validator validator, AccessTokenFactory accessTokenFactory, PrincipalFactory principalFactory, ServiceFactory<WebApplicationService> webApplicationServiceServiceFactory, OAuth20ProfileScopeToAttributesFilter scopeToAttributesFilter, CasConfigurationProperties casProperties, CookieRetrievingCookieGenerator cookieGenerator, OAuth20UserProfileViewRenderer userProfileViewRenderer) {
        super(servicesManager, ticketRegistry, validator, accessTokenFactory, principalFactory, webApplicationServiceServiceFactory, scopeToAttributesFilter, casProperties, cookieGenerator);
        this.userProfileViewRenderer = userProfileViewRenderer;
    }

    @GetMapping(path={"/oauth2.0/profile"}, produces={"application/json"})
    public ResponseEntity<String> handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        response.setContentType("application/json");
        String accessToken = this.getAccessTokenFromRequest(request);
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            LOGGER.error("Missing [{}]", (Object)"access_token");
            return OAuth20UserProfileControllerController.buildUnauthorizedResponseEntity("missing_accessToken");
        }
        AccessToken accessTokenTicket = (AccessToken)this.ticketRegistry.getTicket(accessToken, AccessToken.class);
        if (accessTokenTicket == null || accessTokenTicket.isExpired()) {
            LOGGER.error("Expired/Missing access token: [{}]", (Object)accessToken);
            return OAuth20UserProfileControllerController.buildUnauthorizedResponseEntity("expired_accessToken");
        }
        TicketGrantingTicket ticketGrantingTicket = accessTokenTicket.getGrantingTicket();
        if (ticketGrantingTicket == null || ticketGrantingTicket.isExpired()) {
            LOGGER.error("Ticket granting ticket [{}] parenting access token [{}] has expired or is not found", (Object)ticketGrantingTicket, (Object)accessTokenTicket);
            this.ticketRegistry.deleteTicket(accessToken);
            return OAuth20UserProfileControllerController.buildUnauthorizedResponseEntity("expired_accessToken");
        }
        this.updateAccessTokenUsage(accessTokenTicket);
        Map<String, Object> map = this.writeOutProfileResponse(accessTokenTicket);
        this.finalizeProfileResponse(accessTokenTicket, map);
        String value = this.userProfileViewRenderer.render(map, accessTokenTicket);
        return new ResponseEntity((Object)value, HttpStatus.OK);
    }

    private void finalizeProfileResponse(AccessToken accessTokenTicket, Map<String, Object> map) {
        Service service = accessTokenTicket.getService();
        RegisteredService registeredService = this.servicesManager.findServiceBy(service);
        if (registeredService instanceof OAuthRegisteredService) {
            OAuthRegisteredService oauth = (OAuthRegisteredService)registeredService;
            map.put("client_id", oauth.getClientId());
            map.put("service", service.getId());
        }
    }

    private void updateAccessTokenUsage(AccessToken accessTokenTicket) {
        TicketState accessTokenState = (TicketState)TicketState.class.cast(accessTokenTicket);
        accessTokenState.update();
        if (accessTokenTicket.isExpired()) {
            this.ticketRegistry.deleteTicket(accessTokenTicket.getId());
        } else {
            this.ticketRegistry.updateTicket((Ticket)accessTokenTicket);
        }
    }

    protected String getAccessTokenFromRequest(HttpServletRequest request) {
        String authHeader;
        String accessToken = request.getParameter("access_token");
        if (StringUtils.isBlank((CharSequence)accessToken) && StringUtils.isNotBlank((CharSequence)(authHeader = request.getHeader("Authorization"))) && authHeader.toLowerCase().startsWith("Bearer".toLowerCase() + ' ')) {
            accessToken = authHeader.substring("Bearer".length() + 1);
        }
        LOGGER.debug("[{}]: [{}]", (Object)"access_token", (Object)accessToken);
        return accessToken;
    }

    protected Map<String, Object> writeOutProfileResponse(AccessToken accessToken) {
        Principal principal = accessToken.getAuthentication().getPrincipal();
        LOGGER.debug("Preparing user profile response based on CAS principal [{}]", (Object)principal);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", principal.getId());
        map.put("attributes", principal.getAttributes());
        return map;
    }

    private static ResponseEntity buildUnauthorizedResponseEntity(String code) {
        LinkedMultiValueMap map = new LinkedMultiValueMap(1);
        map.add((Object)"error", (Object)code);
        String value = OAuth20Utils.jsonify((Map)map);
        return new ResponseEntity((Object)value, HttpStatus.UNAUTHORIZED);
    }
}

