/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.response.accesstoken;

import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.DefaultAuthenticationBuilder;
import org.apereo.cas.support.oauth.web.response.accesstoken.OAuth20TokenGenerator;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenRequestDataHolder;
import org.apereo.cas.ticket.OAuthToken;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.TicketState;
import org.apereo.cas.ticket.accesstoken.AccessToken;
import org.apereo.cas.ticket.accesstoken.AccessTokenFactory;
import org.apereo.cas.ticket.code.OAuthCode;
import org.apereo.cas.ticket.refreshtoken.RefreshToken;
import org.apereo.cas.ticket.refreshtoken.RefreshTokenFactory;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth20DefaultTokenGenerator
implements OAuth20TokenGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20DefaultTokenGenerator.class);
    protected final AccessTokenFactory accessTokenFactory;
    protected final RefreshTokenFactory refreshTokenFactory;
    protected final TicketRegistry ticketRegistry;

    public OAuth20DefaultTokenGenerator(AccessTokenFactory accessTokenFactory, TicketRegistry ticketRegistry, RefreshTokenFactory refreshTokenFactory) {
        this.accessTokenFactory = accessTokenFactory;
        this.ticketRegistry = ticketRegistry;
        this.refreshTokenFactory = refreshTokenFactory;
    }

    @Override
    public Pair<AccessToken, RefreshToken> generate(AccessTokenRequestDataHolder holder) {
        LOGGER.debug("Creating refresh token for [{}]", (Object)holder.getService());
        Authentication authn = DefaultAuthenticationBuilder.newInstance((Authentication)holder.getAuthentication()).addAttribute("grant_type", (Object)holder.getGrantType().toString()).build();
        AccessToken accessToken = this.accessTokenFactory.create(holder.getService(), authn, holder.getTicketGrantingTicket(), holder.getScopes());
        LOGGER.debug("Creating access token [{}]", (Object)accessToken);
        this.addTicketToRegistry((OAuthToken)accessToken, holder.getTicketGrantingTicket());
        LOGGER.debug("Added access token [{}] to registry", (Object)accessToken);
        if (holder.getToken() instanceof OAuthCode) {
            TicketState codeState = (TicketState)TicketState.class.cast(holder.getToken());
            codeState.update();
            if (holder.getToken().isExpired()) {
                this.ticketRegistry.deleteTicket(holder.getToken().getId());
            } else {
                this.ticketRegistry.updateTicket((Ticket)holder.getToken());
            }
            this.ticketRegistry.updateTicket((Ticket)holder.getTicketGrantingTicket());
        }
        RefreshToken refreshToken = null;
        if (holder.isGenerateRefreshToken()) {
            refreshToken = this.generateRefreshToken(holder);
            LOGGER.debug("Refresh Token: [{}]", (Object)refreshToken);
        } else {
            LOGGER.debug("Service [{}] is not able/allowed to receive refresh tokens", (Object)holder.getService());
        }
        return Pair.of((Object)accessToken, (Object)refreshToken);
    }

    protected void addTicketToRegistry(OAuthToken ticket, TicketGrantingTicket ticketGrantingTicket) {
        LOGGER.debug("Adding OAuth ticket [{}] to registry", (Object)ticket);
        this.ticketRegistry.addTicket((Ticket)ticket);
        if (ticketGrantingTicket != null) {
            LOGGER.debug("Updating ticket-granting ticket [{}]", (Object)ticketGrantingTicket);
            this.ticketRegistry.updateTicket((Ticket)ticketGrantingTicket);
        }
    }

    private RefreshToken generateRefreshToken(AccessTokenRequestDataHolder responseHolder) {
        LOGGER.debug("Creating refresh token for [{}]", (Object)responseHolder.getService());
        RefreshToken refreshToken = this.refreshTokenFactory.create(responseHolder.getService(), responseHolder.getAuthentication(), responseHolder.getTicketGrantingTicket());
        LOGGER.debug("Adding refresh token [{}] to the registry", (Object)refreshToken);
        this.addTicketToRegistry((OAuthToken)refreshToken, responseHolder.getTicketGrantingTicket());
        return refreshToken;
    }
}

