/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.refreshtoken;

import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketFactory;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.UniqueTicketIdGenerator;
import org.apereo.cas.ticket.refreshtoken.RefreshToken;
import org.apereo.cas.ticket.refreshtoken.RefreshTokenFactory;
import org.apereo.cas.ticket.refreshtoken.RefreshTokenImpl;
import org.apereo.cas.util.DefaultUniqueTicketIdGenerator;

public class DefaultRefreshTokenFactory
implements RefreshTokenFactory {
    protected final UniqueTicketIdGenerator refreshTokenIdGenerator;
    protected final ExpirationPolicy expirationPolicy;

    public DefaultRefreshTokenFactory(ExpirationPolicy expirationPolicy) {
        this((UniqueTicketIdGenerator)new DefaultUniqueTicketIdGenerator(), expirationPolicy);
    }

    public DefaultRefreshTokenFactory(UniqueTicketIdGenerator refreshTokenIdGenerator, ExpirationPolicy expirationPolicy) {
        this.refreshTokenIdGenerator = refreshTokenIdGenerator;
        this.expirationPolicy = expirationPolicy;
    }

    @Override
    public RefreshToken create(Service service, Authentication authentication, TicketGrantingTicket ticketGrantingTicket) {
        String codeId = this.refreshTokenIdGenerator.getNewTicketId("RT");
        RefreshTokenImpl rt = new RefreshTokenImpl(codeId, service, authentication, this.expirationPolicy, ticketGrantingTicket);
        if (ticketGrantingTicket != null) {
            ticketGrantingTicket.getDescendantTickets().add(rt.getId());
        }
        return rt;
    }

    public <T extends TicketFactory> T get(Class<? extends Ticket> clazz) {
        return (T)this;
    }
}

