/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.refreshtoken;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apereo.cas.ticket.TicketState;
import org.apereo.cas.ticket.support.AbstractCasExpirationPolicy;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY)
public class OAuthRefreshTokenExpirationPolicy
extends AbstractCasExpirationPolicy {
    private static final long serialVersionUID = -7144233906843566234L;
    private long timeToKillInSeconds;

    public OAuthRefreshTokenExpirationPolicy() {
    }

    @JsonCreator
    public OAuthRefreshTokenExpirationPolicy(@JsonProperty(value="timeToLive") long timeToKillInSeconds) {
        this.timeToKillInSeconds = timeToKillInSeconds;
    }

    public boolean isExpired(TicketState ticketState) {
        return ticketState == null || ticketState.getCreationTime().plus(this.timeToKillInSeconds, ChronoUnit.SECONDS).isBefore(ZonedDateTime.now(ZoneOffset.UTC));
    }

    public Long getTimeToLive() {
        return this.timeToKillInSeconds;
    }

    @JsonIgnore
    public Long getTimeToIdle() {
        return 0L;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        OAuthRefreshTokenExpirationPolicy rhs = (OAuthRefreshTokenExpirationPolicy)((Object)obj);
        return new EqualsBuilder().append(this.timeToKillInSeconds, rhs.timeToKillInSeconds).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.timeToKillInSeconds).toHashCode();
    }
}

